/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.heapprofiler.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v135.runtime.model.CallFrame;
import org.openqa.selenium.json.JsonInput;

public class SamplingHeapProfileNode {
    private final CallFrame callFrame;
    private final Number selfSize;
    private final Integer id;
    private final List<SamplingHeapProfileNode> children;

    public SamplingHeapProfileNode(CallFrame callFrame, Number selfSize, Integer id, List<SamplingHeapProfileNode> children) {
        this.callFrame = Objects.requireNonNull(callFrame, "callFrame is required");
        this.selfSize = Objects.requireNonNull(selfSize, "selfSize is required");
        this.id = Objects.requireNonNull(id, "id is required");
        this.children = Objects.requireNonNull(children, "children is required");
    }

    public CallFrame getCallFrame() {
        return this.callFrame;
    }

    public Number getSelfSize() {
        return this.selfSize;
    }

    public Integer getId() {
        return this.id;
    }

    public List<SamplingHeapProfileNode> getChildren() {
        return this.children;
    }

    private static SamplingHeapProfileNode fromJson(JsonInput input) {
        CallFrame callFrame = null;
        Number selfSize = 0;
        Integer id = 0;
        List children = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "callFrame": {
                    callFrame = (CallFrame)input.read(CallFrame.class);
                    continue block12;
                }
                case "selfSize": {
                    selfSize = input.nextNumber();
                    continue block12;
                }
                case "id": {
                    id = input.nextNumber().intValue();
                    continue block12;
                }
                case "children": {
                    children = input.readArray(SamplingHeapProfileNode.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SamplingHeapProfileNode(callFrame, selfSize, id, children);
    }
}

