/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v135.page.model.FileFilter;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ShareTarget {
    private final String action;
    private final String method;
    private final String enctype;
    private final Optional<String> title;
    private final Optional<String> text;
    private final Optional<String> url;
    private final Optional<List<FileFilter>> files;

    public ShareTarget(String action, String method, String enctype, Optional<String> title, Optional<String> text, Optional<String> url, Optional<List<FileFilter>> files) {
        this.action = Objects.requireNonNull(action, "action is required");
        this.method = Objects.requireNonNull(method, "method is required");
        this.enctype = Objects.requireNonNull(enctype, "enctype is required");
        this.title = title;
        this.text = text;
        this.url = url;
        this.files = files;
    }

    public String getAction() {
        return this.action;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getText() {
        return this.text;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<List<FileFilter>> getFiles() {
        return this.files;
    }

    private static ShareTarget fromJson(JsonInput input) {
        String action = null;
        String method = null;
        String enctype = null;
        Optional<String> title = Optional.empty();
        Optional<String> text = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<List<FileFilter>> files = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "action": {
                    action = input.nextString();
                    continue block18;
                }
                case "method": {
                    method = input.nextString();
                    continue block18;
                }
                case "enctype": {
                    enctype = input.nextString();
                    continue block18;
                }
                case "title": {
                    title = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "text": {
                    text = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "files": {
                    files = Optional.ofNullable(input.readArray(FileFilter.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ShareTarget(action, method, enctype, title, text, url, files);
    }
}

