/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.overlay.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v135.dom.model.RGBA;
import org.openqa.selenium.json.JsonInput;

public class SourceOrderConfig {
    private final RGBA parentOutlineColor;
    private final RGBA childOutlineColor;

    public SourceOrderConfig(RGBA parentOutlineColor, RGBA childOutlineColor) {
        this.parentOutlineColor = Objects.requireNonNull(parentOutlineColor, "parentOutlineColor is required");
        this.childOutlineColor = Objects.requireNonNull(childOutlineColor, "childOutlineColor is required");
    }

    public RGBA getParentOutlineColor() {
        return this.parentOutlineColor;
    }

    public RGBA getChildOutlineColor() {
        return this.childOutlineColor;
    }

    private static SourceOrderConfig fromJson(JsonInput input) {
        RGBA parentOutlineColor = null;
        RGBA childOutlineColor = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "parentOutlineColor": {
                    parentOutlineColor = (RGBA)input.read(RGBA.class);
                    continue block8;
                }
                case "childOutlineColor": {
                    childOutlineColor = (RGBA)input.read(RGBA.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SourceOrderConfig(parentOutlineColor, childOutlineColor);
    }
}

