package org.openqa.selenium.devtools.v135.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * cookiePartitionKey object
 * The representation of the components of the key that are created by the cookiePartitionKey class contained in net/cookies/cookie_partition_key.h.
 */
@org.openqa.selenium.Beta()
public class CookiePartitionKey {

    private final java.lang.String topLevelSite;

    private final java.lang.Boolean hasCrossSiteAncestor;

    public CookiePartitionKey(java.lang.String topLevelSite, java.lang.Boolean hasCrossSiteAncestor) {
        this.topLevelSite = java.util.Objects.requireNonNull(topLevelSite, "topLevelSite is required");
        this.hasCrossSiteAncestor = java.util.Objects.requireNonNull(hasCrossSiteAncestor, "hasCrossSiteAncestor is required");
    }

    /**
     * The site of the top-level URL the browser was visiting at the start
     * of the request to the endpoint that set the cookie.
     */
    public java.lang.String getTopLevelSite() {
        return topLevelSite;
    }

    /**
     * Indicates if the cookie has any ancestors that are cross-site to the topLevelSite.
     */
    public java.lang.Boolean getHasCrossSiteAncestor() {
        return hasCrossSiteAncestor;
    }

    private static CookiePartitionKey fromJson(JsonInput input) {
        java.lang.String topLevelSite = null;
        java.lang.Boolean hasCrossSiteAncestor = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "topLevelSite":
                    topLevelSite = input.nextString();
                    break;
                case "hasCrossSiteAncestor":
                    hasCrossSiteAncestor = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookiePartitionKey(topLevelSite, hasCrossSiteAncestor);
    }
}
