package org.openqa.selenium.devtools.v135.deviceaccess;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class DeviceAccess {

    /**
     * Enable events in this domain.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("DeviceAccess.enable", Map.copyOf(params));
    }

    /**
     * Disable events in this domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("DeviceAccess.disable", Map.copyOf(params));
    }

    /**
     * Select a device in response to a DeviceAccess.deviceRequestPrompted event.
     */
    public static Command<Void> selectPrompt(org.openqa.selenium.devtools.v135.deviceaccess.model.RequestId id, org.openqa.selenium.devtools.v135.deviceaccess.model.DeviceId deviceId) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(deviceId, "deviceId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        params.put("deviceId", deviceId);
        return new Command<>("DeviceAccess.selectPrompt", Map.copyOf(params));
    }

    /**
     * Cancel a prompt in response to a DeviceAccess.deviceRequestPrompted event.
     */
    public static Command<Void> cancelPrompt(org.openqa.selenium.devtools.v135.deviceaccess.model.RequestId id) {
        java.util.Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        return new Command<>("DeviceAccess.cancelPrompt", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v135.deviceaccess.model.DeviceRequestPrompted> deviceRequestPrompted() {
        return new Event<>("DeviceAccess.deviceRequestPrompted", input -> input.read(org.openqa.selenium.devtools.v135.deviceaccess.model.DeviceRequestPrompted.class));
    }
}
