package org.openqa.selenium.devtools.v135.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class SRIMessageSignatureIssueDetails {

    private final org.openqa.selenium.devtools.v135.audits.model.SRIMessageSignatureError error;

    private final org.openqa.selenium.devtools.v135.audits.model.AffectedRequest request;

    public SRIMessageSignatureIssueDetails(org.openqa.selenium.devtools.v135.audits.model.SRIMessageSignatureError error, org.openqa.selenium.devtools.v135.audits.model.AffectedRequest request) {
        this.error = java.util.Objects.requireNonNull(error, "error is required");
        this.request = java.util.Objects.requireNonNull(request, "request is required");
    }

    public org.openqa.selenium.devtools.v135.audits.model.SRIMessageSignatureError getError() {
        return error;
    }

    public org.openqa.selenium.devtools.v135.audits.model.AffectedRequest getRequest() {
        return request;
    }

    private static SRIMessageSignatureIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v135.audits.model.SRIMessageSignatureError error = null;
        org.openqa.selenium.devtools.v135.audits.model.AffectedRequest request = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "error":
                    error = input.read(org.openqa.selenium.devtools.v135.audits.model.SRIMessageSignatureError.class);
                    break;
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v135.audits.model.AffectedRequest.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SRIMessageSignatureIssueDetails(error, request);
    }
}
