package org.openqa.selenium.devtools.v133.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionScopesData {

    private final java.util.List<java.lang.String> values;

    private final java.lang.Number limit;

    private final java.lang.Number maxEventStates;

    public AttributionScopesData(java.util.List<java.lang.String> values, java.lang.Number limit, java.lang.Number maxEventStates) {
        this.values = java.util.Objects.requireNonNull(values, "values is required");
        this.limit = java.util.Objects.requireNonNull(limit, "limit is required");
        this.maxEventStates = java.util.Objects.requireNonNull(maxEventStates, "maxEventStates is required");
    }

    public java.util.List<java.lang.String> getValues() {
        return values;
    }

    /**
     * number instead of integer because not all uint32 can be represented by
     * int
     */
    public java.lang.Number getLimit() {
        return limit;
    }

    public java.lang.Number getMaxEventStates() {
        return maxEventStates;
    }

    private static AttributionScopesData fromJson(JsonInput input) {
        java.util.List<java.lang.String> values = null;
        java.lang.Number limit = 0;
        java.lang.Number maxEventStates = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "values":
                    values = input.readArray(java.lang.String.class);
                    break;
                case "limit":
                    limit = input.nextNumber();
                    break;
                case "maxEventStates":
                    maxEventStates = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionScopesData(values, limit, maxEventStates);
    }
}
