package org.openqa.selenium.devtools.v133.input.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DragDataItem {

    private final java.lang.String mimeType;

    private final java.lang.String data;

    private final java.util.Optional<java.lang.String> title;

    private final java.util.Optional<java.lang.String> baseURL;

    public DragDataItem(java.lang.String mimeType, java.lang.String data, java.util.Optional<java.lang.String> title, java.util.Optional<java.lang.String> baseURL) {
        this.mimeType = java.util.Objects.requireNonNull(mimeType, "mimeType is required");
        this.data = java.util.Objects.requireNonNull(data, "data is required");
        this.title = title;
        this.baseURL = baseURL;
    }

    /**
     * Mime type of the dragged data.
     */
    public java.lang.String getMimeType() {
        return mimeType;
    }

    /**
     * Depending of the value of `mimeType`, it contains the dragged link,
     * text, HTML markup or any other data.
     */
    public java.lang.String getData() {
        return data;
    }

    /**
     * Title associated with a link. Only valid when `mimeType` == "text/uri-list".
     */
    public java.util.Optional<java.lang.String> getTitle() {
        return title;
    }

    /**
     * Stores the base URL for the contained markup. Only valid when `mimeType`
     * == "text/html".
     */
    public java.util.Optional<java.lang.String> getBaseURL() {
        return baseURL;
    }

    private static DragDataItem fromJson(JsonInput input) {
        java.lang.String mimeType = null;
        java.lang.String data = null;
        java.util.Optional<java.lang.String> title = java.util.Optional.empty();
        java.util.Optional<java.lang.String> baseURL = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "mimeType":
                    mimeType = input.nextString();
                    break;
                case "data":
                    data = input.nextString();
                    break;
                case "title":
                    title = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "baseURL":
                    baseURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DragDataItem(mimeType, data, title, baseURL);
    }
}
