/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.indexeddb.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class Key {
    private final Type type;
    private final Optional<Number> number;
    private final Optional<String> string;
    private final Optional<Number> date;
    private final Optional<List<Key>> array;

    public Key(Type type, Optional<Number> number, Optional<String> string, Optional<Number> date, Optional<List<Key>> array) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.number = number;
        this.string = string;
        this.date = date;
        this.array = array;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Number> getNumber() {
        return this.number;
    }

    public Optional<String> getString() {
        return this.string;
    }

    public Optional<Number> getDate() {
        return this.date;
    }

    public Optional<List<Key>> getArray() {
        return this.array;
    }

    private static Key fromJson(JsonInput input) {
        Type type = null;
        Optional<Number> number = Optional.empty();
        Optional<String> string = Optional.empty();
        Optional<Number> date = Optional.empty();
        Optional<List<Key>> array = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block14;
                }
                case "number": {
                    number = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "string": {
                    string = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "date": {
                    date = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "array": {
                    array = Optional.ofNullable(input.readArray(Key.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Key(type, number, string, date, array);
    }

    public static enum Type {
        NUMBER("number"),
        STRING("string"),
        DATE("date"),
        ARRAY("array");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

