package org.openqa.selenium.devtools.v132.systeminfo.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Describes a single graphics processor (GPU).
 */
public class GPUDevice {

    private final java.lang.Number vendorId;

    private final java.lang.Number deviceId;

    private final java.util.Optional<java.lang.Number> subSysId;

    private final java.util.Optional<java.lang.Number> revision;

    private final java.lang.String vendorString;

    private final java.lang.String deviceString;

    private final java.lang.String driverVendor;

    private final java.lang.String driverVersion;

    public GPUDevice(java.lang.Number vendorId, java.lang.Number deviceId, java.util.Optional<java.lang.Number> subSysId, java.util.Optional<java.lang.Number> revision, java.lang.String vendorString, java.lang.String deviceString, java.lang.String driverVendor, java.lang.String driverVersion) {
        this.vendorId = java.util.Objects.requireNonNull(vendorId, "vendorId is required");
        this.deviceId = java.util.Objects.requireNonNull(deviceId, "deviceId is required");
        this.subSysId = subSysId;
        this.revision = revision;
        this.vendorString = java.util.Objects.requireNonNull(vendorString, "vendorString is required");
        this.deviceString = java.util.Objects.requireNonNull(deviceString, "deviceString is required");
        this.driverVendor = java.util.Objects.requireNonNull(driverVendor, "driverVendor is required");
        this.driverVersion = java.util.Objects.requireNonNull(driverVersion, "driverVersion is required");
    }

    /**
     * PCI ID of the GPU vendor, if available; 0 otherwise.
     */
    public java.lang.Number getVendorId() {
        return vendorId;
    }

    /**
     * PCI ID of the GPU device, if available; 0 otherwise.
     */
    public java.lang.Number getDeviceId() {
        return deviceId;
    }

    /**
     * Sub sys ID of the GPU, only available on Windows.
     */
    public java.util.Optional<java.lang.Number> getSubSysId() {
        return subSysId;
    }

    /**
     * Revision of the GPU, only available on Windows.
     */
    public java.util.Optional<java.lang.Number> getRevision() {
        return revision;
    }

    /**
     * String description of the GPU vendor, if the PCI ID is not available.
     */
    public java.lang.String getVendorString() {
        return vendorString;
    }

    /**
     * String description of the GPU device, if the PCI ID is not available.
     */
    public java.lang.String getDeviceString() {
        return deviceString;
    }

    /**
     * String description of the GPU driver vendor.
     */
    public java.lang.String getDriverVendor() {
        return driverVendor;
    }

    /**
     * String description of the GPU driver version.
     */
    public java.lang.String getDriverVersion() {
        return driverVersion;
    }

    private static GPUDevice fromJson(JsonInput input) {
        java.lang.Number vendorId = 0;
        java.lang.Number deviceId = 0;
        java.util.Optional<java.lang.Number> subSysId = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> revision = java.util.Optional.empty();
        java.lang.String vendorString = null;
        java.lang.String deviceString = null;
        java.lang.String driverVendor = null;
        java.lang.String driverVersion = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "vendorId":
                    vendorId = input.nextNumber();
                    break;
                case "deviceId":
                    deviceId = input.nextNumber();
                    break;
                case "subSysId":
                    subSysId = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "revision":
                    revision = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "vendorString":
                    vendorString = input.nextString();
                    break;
                case "deviceString":
                    deviceString = input.nextString();
                    break;
                case "driverVendor":
                    driverVendor = input.nextString();
                    break;
                case "driverVersion":
                    driverVersion = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GPUDevice(vendorId, deviceId, subSysId, revision, vendorString, deviceString, driverVendor, driverVersion);
    }
}
