package org.openqa.selenium.devtools.v132.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when same-document navigation happens, e.g. due to history API usage or anchor navigation.
 */
@org.openqa.selenium.Beta()
public class NavigatedWithinDocument {

    public enum NavigationType {

        FRAGMENT("fragment"), HISTORYAPI("historyApi"), OTHER("other");

        private String value;

        NavigationType(String value) {
            this.value = value;
        }

        public static NavigationType fromString(String s) {
            return java.util.Arrays.stream(NavigationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within NavigationType "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static NavigationType fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v132.page.model.FrameId frameId;

    private final java.lang.String url;

    private final NavigationType navigationType;

    public NavigatedWithinDocument(org.openqa.selenium.devtools.v132.page.model.FrameId frameId, java.lang.String url, NavigationType navigationType) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.navigationType = java.util.Objects.requireNonNull(navigationType, "navigationType is required");
    }

    /**
     * Id of the frame.
     */
    public org.openqa.selenium.devtools.v132.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Frame's new url.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Navigation type
     */
    public NavigationType getNavigationType() {
        return navigationType;
    }

    private static NavigatedWithinDocument fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.page.model.FrameId frameId = null;
        java.lang.String url = null;
        NavigationType navigationType = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v132.page.model.FrameId.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "navigationType":
                    navigationType = NavigationType.fromString(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new NavigatedWithinDocument(frameId, url, navigationType);
    }
}
