package org.openqa.selenium.devtools.v132.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The reason why Chrome uses a specific transport protocol for HTTP semantics.
 */
@org.openqa.selenium.Beta()
public enum AlternateProtocolUsage {

    ALTERNATIVEJOBWONWITHOUTRACE("alternativeJobWonWithoutRace"),
    ALTERNATIVEJOBWONRACE("alternativeJobWonRace"),
    MAINJOBWONRACE("mainJobWonRace"),
    MAPPINGMISSING("mappingMissing"),
    BROKEN("broken"),
    DNSALPNH3JOBWONWITHOUTRACE("dnsAlpnH3JobWonWithoutRace"),
    DNSALPNH3JOBWONRACE("dnsAlpnH3JobWonRace"),
    UNSPECIFIEDREASON("unspecifiedReason");

    private String value;

    AlternateProtocolUsage(String value) {
        this.value = value;
    }

    public static AlternateProtocolUsage fromString(String s) {
        return java.util.Arrays.stream(AlternateProtocolUsage.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AlternateProtocolUsage "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AlternateProtocolUsage fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
