package org.openqa.selenium.devtools.v132.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Stores the manufacturer data
 */
public class ManufacturerData {

    private final java.lang.Integer key;

    private final java.lang.String data;

    public ManufacturerData(java.lang.Integer key, java.lang.String data) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.data = java.util.Objects.requireNonNull(data, "data is required");
    }

    /**
     * Company identifier
     * https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml
     * https://usb.org/developers
     */
    public java.lang.Integer getKey() {
        return key;
    }

    /**
     * Manufacturer-specific data
     */
    public java.lang.String getData() {
        return data;
    }

    private static ManufacturerData fromJson(JsonInput input) {
        java.lang.Integer key = 0;
        java.lang.String data = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.nextNumber().intValue();
                    break;
                case "data":
                    data = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ManufacturerData(key, data);
    }
}
