package org.openqa.selenium.devtools.v132.animation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Timeline instance
 */
public class ViewOrScrollTimeline {

    private final java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> sourceNodeId;

    private final java.util.Optional<java.lang.Number> startOffset;

    private final java.util.Optional<java.lang.Number> endOffset;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> subjectNodeId;

    private final org.openqa.selenium.devtools.v132.dom.model.ScrollOrientation axis;

    public ViewOrScrollTimeline(java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> sourceNodeId, java.util.Optional<java.lang.Number> startOffset, java.util.Optional<java.lang.Number> endOffset, java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> subjectNodeId, org.openqa.selenium.devtools.v132.dom.model.ScrollOrientation axis) {
        this.sourceNodeId = sourceNodeId;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.subjectNodeId = subjectNodeId;
        this.axis = java.util.Objects.requireNonNull(axis, "axis is required");
    }

    /**
     * Scroll container node
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> getSourceNodeId() {
        return sourceNodeId;
    }

    /**
     * Represents the starting scroll position of the timeline
     * as a length offset in pixels from scroll origin.
     */
    public java.util.Optional<java.lang.Number> getStartOffset() {
        return startOffset;
    }

    /**
     * Represents the ending scroll position of the timeline
     * as a length offset in pixels from scroll origin.
     */
    public java.util.Optional<java.lang.Number> getEndOffset() {
        return endOffset;
    }

    /**
     * The element whose principal box's visibility in the
     * scrollport defined the progress of the timeline.
     * Does not exist for animations with ScrollTimeline
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> getSubjectNodeId() {
        return subjectNodeId;
    }

    /**
     * Orientation of the scroll
     */
    public org.openqa.selenium.devtools.v132.dom.model.ScrollOrientation getAxis() {
        return axis;
    }

    private static ViewOrScrollTimeline fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> sourceNodeId = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> startOffset = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> endOffset = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> subjectNodeId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v132.dom.model.ScrollOrientation axis = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceNodeId":
                    sourceNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.dom.model.BackendNodeId.class));
                    break;
                case "startOffset":
                    startOffset = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "endOffset":
                    endOffset = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "subjectNodeId":
                    subjectNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.dom.model.BackendNodeId.class));
                    break;
                case "axis":
                    axis = input.read(org.openqa.selenium.devtools.v132.dom.model.ScrollOrientation.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ViewOrScrollTimeline(sourceNodeId, startOffset, endOffset, subjectNodeId, axis);
    }
}
