/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.storage.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v130.storage.model.AttributionReportingAggregatableDebugReportingData;
import org.openqa.selenium.devtools.v130.storage.model.UnsignedInt128AsBase16;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingAggregatableDebugReportingConfig {
    private final Optional<Number> budget;
    private final UnsignedInt128AsBase16 keyPiece;
    private final List<AttributionReportingAggregatableDebugReportingData> debugData;
    private final Optional<String> aggregationCoordinatorOrigin;

    public AttributionReportingAggregatableDebugReportingConfig(Optional<Number> budget, UnsignedInt128AsBase16 keyPiece, List<AttributionReportingAggregatableDebugReportingData> debugData, Optional<String> aggregationCoordinatorOrigin) {
        this.budget = budget;
        this.keyPiece = Objects.requireNonNull(keyPiece, "keyPiece is required");
        this.debugData = Objects.requireNonNull(debugData, "debugData is required");
        this.aggregationCoordinatorOrigin = aggregationCoordinatorOrigin;
    }

    public Optional<Number> getBudget() {
        return this.budget;
    }

    public UnsignedInt128AsBase16 getKeyPiece() {
        return this.keyPiece;
    }

    public List<AttributionReportingAggregatableDebugReportingData> getDebugData() {
        return this.debugData;
    }

    public Optional<String> getAggregationCoordinatorOrigin() {
        return this.aggregationCoordinatorOrigin;
    }

    private static AttributionReportingAggregatableDebugReportingConfig fromJson(JsonInput input) {
        Optional<Number> budget = Optional.empty();
        UnsignedInt128AsBase16 keyPiece = null;
        List debugData = null;
        Optional<String> aggregationCoordinatorOrigin = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "budget": {
                    budget = Optional.ofNullable(input.nextNumber());
                    continue block12;
                }
                case "keyPiece": {
                    keyPiece = (UnsignedInt128AsBase16)input.read(UnsignedInt128AsBase16.class);
                    continue block12;
                }
                case "debugData": {
                    debugData = input.readArray(AttributionReportingAggregatableDebugReportingData.class);
                    continue block12;
                }
                case "aggregationCoordinatorOrigin": {
                    aggregationCoordinatorOrigin = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingAggregatableDebugReportingConfig(budget, keyPiece, debugData, aggregationCoordinatorOrigin);
    }
}

