/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.audits.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v130.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v130.network.model.LoaderId;
import org.openqa.selenium.devtools.v130.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class QuirksModeIssueDetails {
    private final Boolean isLimitedQuirksMode;
    private final BackendNodeId documentNodeId;
    private final String url;
    private final FrameId frameId;
    private final LoaderId loaderId;

    public QuirksModeIssueDetails(Boolean isLimitedQuirksMode, BackendNodeId documentNodeId, String url, FrameId frameId, LoaderId loaderId) {
        this.isLimitedQuirksMode = Objects.requireNonNull(isLimitedQuirksMode, "isLimitedQuirksMode is required");
        this.documentNodeId = Objects.requireNonNull(documentNodeId, "documentNodeId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
    }

    public Boolean getIsLimitedQuirksMode() {
        return this.isLimitedQuirksMode;
    }

    public BackendNodeId getDocumentNodeId() {
        return this.documentNodeId;
    }

    public String getUrl() {
        return this.url;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    private static QuirksModeIssueDetails fromJson(JsonInput input) {
        Boolean isLimitedQuirksMode = false;
        BackendNodeId documentNodeId = null;
        String url = null;
        FrameId frameId = null;
        LoaderId loaderId = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "isLimitedQuirksMode": {
                    isLimitedQuirksMode = input.nextBoolean();
                    continue block14;
                }
                case "documentNodeId": {
                    documentNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block14;
                }
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new QuirksModeIssueDetails(isLimitedQuirksMode, documentNodeId, url, frameId, loaderId);
    }
}

