/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.preload.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v129.network.model.LoaderId;
import org.openqa.selenium.devtools.v129.preload.model.SpeculationAction;
import org.openqa.selenium.devtools.v129.preload.model.SpeculationTargetHint;
import org.openqa.selenium.json.JsonInput;

public class PreloadingAttemptKey {
    private final LoaderId loaderId;
    private final SpeculationAction action;
    private final String url;
    private final Optional<SpeculationTargetHint> targetHint;

    public PreloadingAttemptKey(LoaderId loaderId, SpeculationAction action, String url, Optional<SpeculationTargetHint> targetHint) {
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.action = Objects.requireNonNull(action, "action is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.targetHint = targetHint;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public SpeculationAction getAction() {
        return this.action;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<SpeculationTargetHint> getTargetHint() {
        return this.targetHint;
    }

    private static PreloadingAttemptKey fromJson(JsonInput input) {
        LoaderId loaderId = null;
        SpeculationAction action = null;
        String url = null;
        Optional<SpeculationTargetHint> targetHint = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block12;
                }
                case "action": {
                    action = (SpeculationAction)((Object)input.read(SpeculationAction.class));
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "targetHint": {
                    targetHint = Optional.ofNullable((SpeculationTargetHint)((Object)input.read(SpeculationTargetHint.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PreloadingAttemptKey(loaderId, action, url, targetHint);
    }
}

