package org.openqa.selenium.devtools.v129.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Send a list of sources for all preloading attempts in a document.
 */
public class PreloadingAttemptSourcesUpdated {

    private final org.openqa.selenium.devtools.v129.network.model.LoaderId loaderId;

    private final java.util.List<org.openqa.selenium.devtools.v129.preload.model.PreloadingAttemptSource> preloadingAttemptSources;

    public PreloadingAttemptSourcesUpdated(org.openqa.selenium.devtools.v129.network.model.LoaderId loaderId, java.util.List<org.openqa.selenium.devtools.v129.preload.model.PreloadingAttemptSource> preloadingAttemptSources) {
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.preloadingAttemptSources = java.util.Objects.requireNonNull(preloadingAttemptSources, "preloadingAttemptSources is required");
    }

    public org.openqa.selenium.devtools.v129.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    public java.util.List<org.openqa.selenium.devtools.v129.preload.model.PreloadingAttemptSource> getPreloadingAttemptSources() {
        return preloadingAttemptSources;
    }

    private static PreloadingAttemptSourcesUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v129.network.model.LoaderId loaderId = null;
        java.util.List<org.openqa.selenium.devtools.v129.preload.model.PreloadingAttemptSource> preloadingAttemptSources = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v129.network.model.LoaderId.class);
                    break;
                case "preloadingAttemptSources":
                    preloadingAttemptSources = input.readArray(org.openqa.selenium.devtools.v129.preload.model.PreloadingAttemptSource.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreloadingAttemptSourcesUpdated(loaderId, preloadingAttemptSources);
    }
}
