package org.openqa.selenium.devtools.v129.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * All Permissions Policy features. This enum should match the one defined
 * in third_party/blink/renderer/core/permissions_policy/permissions_policy_features.json5.
 */
@org.openqa.selenium.Beta()
public enum PermissionsPolicyFeature {

    ACCELEROMETER("accelerometer"),
    ALL_SCREENS_CAPTURE("all-screens-capture"),
    AMBIENT_LIGHT_SENSOR("ambient-light-sensor"),
    ATTRIBUTION_REPORTING("attribution-reporting"),
    AUTOPLAY("autoplay"),
    BLUETOOTH("bluetooth"),
    BROWSING_TOPICS("browsing-topics"),
    CAMERA("camera"),
    CAPTURED_SURFACE_CONTROL("captured-surface-control"),
    CH_DPR("ch-dpr"),
    CH_DEVICE_MEMORY("ch-device-memory"),
    CH_DOWNLINK("ch-downlink"),
    CH_ECT("ch-ect"),
    CH_PREFERS_COLOR_SCHEME("ch-prefers-color-scheme"),
    CH_PREFERS_REDUCED_MOTION("ch-prefers-reduced-motion"),
    CH_PREFERS_REDUCED_TRANSPARENCY("ch-prefers-reduced-transparency"),
    CH_RTT("ch-rtt"),
    CH_SAVE_DATA("ch-save-data"),
    CH_UA("ch-ua"),
    CH_UA_ARCH("ch-ua-arch"),
    CH_UA_BITNESS("ch-ua-bitness"),
    CH_UA_PLATFORM("ch-ua-platform"),
    CH_UA_MODEL("ch-ua-model"),
    CH_UA_MOBILE("ch-ua-mobile"),
    CH_UA_FORM_FACTORS("ch-ua-form-factors"),
    CH_UA_FULL_VERSION("ch-ua-full-version"),
    CH_UA_FULL_VERSION_LIST("ch-ua-full-version-list"),
    CH_UA_PLATFORM_VERSION("ch-ua-platform-version"),
    CH_UA_WOW64("ch-ua-wow64"),
    CH_VIEWPORT_HEIGHT("ch-viewport-height"),
    CH_VIEWPORT_WIDTH("ch-viewport-width"),
    CH_WIDTH("ch-width"),
    CLIPBOARD_READ("clipboard-read"),
    CLIPBOARD_WRITE("clipboard-write"),
    COMPUTE_PRESSURE("compute-pressure"),
    CROSS_ORIGIN_ISOLATED("cross-origin-isolated"),
    DEFERRED_FETCH("deferred-fetch"),
    DIGITAL_CREDENTIALS_GET("digital-credentials-get"),
    DIRECT_SOCKETS("direct-sockets"),
    DISPLAY_CAPTURE("display-capture"),
    DOCUMENT_DOMAIN("document-domain"),
    ENCRYPTED_MEDIA("encrypted-media"),
    EXECUTION_WHILE_OUT_OF_VIEWPORT("execution-while-out-of-viewport"),
    EXECUTION_WHILE_NOT_RENDERED("execution-while-not-rendered"),
    FOCUS_WITHOUT_USER_ACTIVATION("focus-without-user-activation"),
    FULLSCREEN("fullscreen"),
    FROBULATE("frobulate"),
    GAMEPAD("gamepad"),
    GEOLOCATION("geolocation"),
    GYROSCOPE("gyroscope"),
    HID("hid"),
    IDENTITY_CREDENTIALS_GET("identity-credentials-get"),
    IDLE_DETECTION("idle-detection"),
    INTEREST_COHORT("interest-cohort"),
    JOIN_AD_INTEREST_GROUP("join-ad-interest-group"),
    KEYBOARD_MAP("keyboard-map"),
    LOCAL_FONTS("local-fonts"),
    MAGNETOMETER("magnetometer"),
    MEDIA_PLAYBACK_WHILE_NOT_VISIBLE("media-playback-while-not-visible"),
    MICROPHONE("microphone"),
    MIDI("midi"),
    OTP_CREDENTIALS("otp-credentials"),
    PAYMENT("payment"),
    PICTURE_IN_PICTURE("picture-in-picture"),
    PRIVATE_AGGREGATION("private-aggregation"),
    PRIVATE_STATE_TOKEN_ISSUANCE("private-state-token-issuance"),
    PRIVATE_STATE_TOKEN_REDEMPTION("private-state-token-redemption"),
    PUBLICKEY_CREDENTIALS_CREATE("publickey-credentials-create"),
    PUBLICKEY_CREDENTIALS_GET("publickey-credentials-get"),
    RUN_AD_AUCTION("run-ad-auction"),
    SCREEN_WAKE_LOCK("screen-wake-lock"),
    SERIAL("serial"),
    SHARED_AUTOFILL("shared-autofill"),
    SHARED_STORAGE("shared-storage"),
    SHARED_STORAGE_SELECT_URL("shared-storage-select-url"),
    SMART_CARD("smart-card"),
    SPEAKER_SELECTION("speaker-selection"),
    STORAGE_ACCESS("storage-access"),
    SUB_APPS("sub-apps"),
    SYNC_XHR("sync-xhr"),
    UNLOAD("unload"),
    USB("usb"),
    USB_UNRESTRICTED("usb-unrestricted"),
    VERTICAL_SCROLL("vertical-scroll"),
    WEB_PRINTING("web-printing"),
    WEB_SHARE("web-share"),
    WINDOW_MANAGEMENT("window-management"),
    XR_SPATIAL_TRACKING("xr-spatial-tracking");

    private String value;

    PermissionsPolicyFeature(String value) {
        this.value = value;
    }

    public static PermissionsPolicyFeature fromString(String s) {
        return java.util.Arrays.stream(PermissionsPolicyFeature.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PermissionsPolicyFeature "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PermissionsPolicyFeature fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
