/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.overlay.model;

import java.util.Optional;
import org.openqa.selenium.devtools.v128.overlay.model.BoxStyle;
import org.openqa.selenium.devtools.v128.overlay.model.LineStyle;
import org.openqa.selenium.json.JsonInput;

public class FlexItemHighlightConfig {
    private final Optional<BoxStyle> baseSizeBox;
    private final Optional<LineStyle> baseSizeBorder;
    private final Optional<LineStyle> flexibilityArrow;

    public FlexItemHighlightConfig(Optional<BoxStyle> baseSizeBox, Optional<LineStyle> baseSizeBorder, Optional<LineStyle> flexibilityArrow) {
        this.baseSizeBox = baseSizeBox;
        this.baseSizeBorder = baseSizeBorder;
        this.flexibilityArrow = flexibilityArrow;
    }

    public Optional<BoxStyle> getBaseSizeBox() {
        return this.baseSizeBox;
    }

    public Optional<LineStyle> getBaseSizeBorder() {
        return this.baseSizeBorder;
    }

    public Optional<LineStyle> getFlexibilityArrow() {
        return this.flexibilityArrow;
    }

    private static FlexItemHighlightConfig fromJson(JsonInput input) {
        Optional<BoxStyle> baseSizeBox = Optional.empty();
        Optional<LineStyle> baseSizeBorder = Optional.empty();
        Optional<LineStyle> flexibilityArrow = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "baseSizeBox": {
                    baseSizeBox = Optional.ofNullable((BoxStyle)input.read(BoxStyle.class));
                    continue block10;
                }
                case "baseSizeBorder": {
                    baseSizeBorder = Optional.ofNullable((LineStyle)input.read(LineStyle.class));
                    continue block10;
                }
                case "flexibilityArrow": {
                    flexibilityArrow = Optional.ofNullable((LineStyle)input.read(LineStyle.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FlexItemHighlightConfig(baseSizeBox, baseSizeBorder, flexibilityArrow);
    }
}

