/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v127.domstorage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v127.domstorage.model.DomStorageItemAdded;
import org.openqa.selenium.devtools.v127.domstorage.model.DomStorageItemRemoved;
import org.openqa.selenium.devtools.v127.domstorage.model.DomStorageItemUpdated;
import org.openqa.selenium.devtools.v127.domstorage.model.Item;
import org.openqa.selenium.devtools.v127.domstorage.model.StorageId;

@Beta
public class DOMStorage {
    public static Command<Void> clear(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, StorageId> params = new LinkedHashMap<String, StorageId>();
        params.put("storageId", storageId);
        return new Command("DOMStorage.clear", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOMStorage.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOMStorage.enable", Map.copyOf(params));
    }

    public static Command<List<Item>> getDOMStorageItems(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        LinkedHashMap<String, StorageId> params = new LinkedHashMap<String, StorageId>();
        params.put("storageId", storageId);
        return new Command("DOMStorage.getDOMStorageItems", Map.copyOf(params), ConverterFunctions.map((String)"entries", input -> input.readArray(Item.class)));
    }

    public static Command<Void> removeDOMStorageItem(StorageId storageId, String key) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageId", storageId);
        params.put("key", key);
        return new Command("DOMStorage.removeDOMStorageItem", Map.copyOf(params));
    }

    public static Command<Void> setDOMStorageItem(StorageId storageId, String key, String value) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageId", storageId);
        params.put("key", key);
        params.put("value", value);
        return new Command("DOMStorage.setDOMStorageItem", Map.copyOf(params));
    }

    public static Event<DomStorageItemAdded> domStorageItemAdded() {
        return new Event("DOMStorage.domStorageItemAdded", input -> (DomStorageItemAdded)input.read(DomStorageItemAdded.class));
    }

    public static Event<DomStorageItemRemoved> domStorageItemRemoved() {
        return new Event("DOMStorage.domStorageItemRemoved", input -> (DomStorageItemRemoved)input.read(DomStorageItemRemoved.class));
    }

    public static Event<DomStorageItemUpdated> domStorageItemUpdated() {
        return new Event("DOMStorage.domStorageItemUpdated", input -> (DomStorageItemUpdated)input.read(DomStorageItemUpdated.class));
    }

    public static Event<StorageId> domStorageItemsCleared() {
        return new Event("DOMStorage.domStorageItemsCleared", ConverterFunctions.map((String)"storageId", StorageId.class));
    }
}

