/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v126.fetch;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v126.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v126.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v126.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v126.fetch.model.RequestId;
import org.openqa.selenium.devtools.v126.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v126.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v126.io.model.StreamHandle;
import org.openqa.selenium.devtools.v126.network.model.ErrorReason;
import org.openqa.selenium.json.JsonInput;

public class Fetch {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Fetch.disable", Map.copyOf(params));
    }

    public static Command<Void> enable(Optional<List<RequestPattern>> patterns, Optional<Boolean> handleAuthRequests) {
        LinkedHashMap params = new LinkedHashMap();
        patterns.ifPresent(p -> params.put("patterns", p));
        handleAuthRequests.ifPresent(p -> params.put("handleAuthRequests", p));
        return new Command("Fetch.enable", Map.copyOf(params));
    }

    public static Command<Void> failRequest(RequestId requestId, ErrorReason errorReason) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(errorReason, "errorReason is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("errorReason", (Object)errorReason);
        return new Command("Fetch.failRequest", Map.copyOf(params));
    }

    public static Command<Void> fulfillRequest(RequestId requestId, Integer responseCode, Optional<List<HeaderEntry>> responseHeaders, Optional<String> binaryResponseHeaders, Optional<String> body, Optional<String> responsePhrase) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(responseCode, "responseCode is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("responseCode", responseCode);
        responseHeaders.ifPresent(p -> params.put("responseHeaders", p));
        binaryResponseHeaders.ifPresent(p -> params.put("binaryResponseHeaders", p));
        body.ifPresent(p -> params.put("body", p));
        responsePhrase.ifPresent(p -> params.put("responsePhrase", p));
        return new Command("Fetch.fulfillRequest", Map.copyOf(params));
    }

    public static Command<Void> continueRequest(RequestId requestId, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<List<HeaderEntry>> headers, Optional<Boolean> interceptResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        url.ifPresent(p -> params.put("url", (RequestId)p));
        method.ifPresent(p -> params.put("method", (RequestId)p));
        postData.ifPresent(p -> params.put("postData", (RequestId)p));
        headers.ifPresent(p -> params.put("headers", (RequestId)p));
        interceptResponse.ifPresent(p -> params.put("interceptResponse", (RequestId)p));
        return new Command("Fetch.continueRequest", Map.copyOf(params));
    }

    public static Command<Void> continueWithAuth(RequestId requestId, AuthChallengeResponse authChallengeResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(authChallengeResponse, "authChallengeResponse is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("authChallengeResponse", authChallengeResponse);
        return new Command("Fetch.continueWithAuth", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> continueResponse(RequestId requestId, Optional<Integer> responseCode, Optional<String> responsePhrase, Optional<List<HeaderEntry>> responseHeaders, Optional<String> binaryResponseHeaders) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        responseCode.ifPresent(p -> params.put("responseCode", (RequestId)p));
        responsePhrase.ifPresent(p -> params.put("responsePhrase", (RequestId)p));
        responseHeaders.ifPresent(p -> params.put("responseHeaders", (RequestId)p));
        binaryResponseHeaders.ifPresent(p -> params.put("binaryResponseHeaders", (RequestId)p));
        return new Command("Fetch.continueResponse", Map.copyOf(params));
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command("Fetch.getResponseBody", Map.copyOf(params), input -> (GetResponseBodyResponse)input.read(GetResponseBodyResponse.class));
    }

    public static Command<StreamHandle> takeResponseBodyAsStream(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command("Fetch.takeResponseBodyAsStream", Map.copyOf(params), ConverterFunctions.map((String)"stream", StreamHandle.class));
    }

    public static Event<RequestPaused> requestPaused() {
        return new Event("Fetch.requestPaused", input -> (RequestPaused)input.read(RequestPaused.class));
    }

    public static Event<AuthRequired> authRequired() {
        return new Event("Fetch.authRequired", input -> (AuthRequired)input.read(AuthRequired.class));
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

