package org.openqa.selenium.devtools.v126.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum indicating the type of a CSS rule, used to represent the order of a style rule's ancestors.
 * This list only contains rule types that are collected during the ancestor rule collection.
 */
@org.openqa.selenium.Beta()
public enum CSSRuleType {

    MEDIARULE("MediaRule"),
    SUPPORTSRULE("SupportsRule"),
    CONTAINERRULE("ContainerRule"),
    LAYERRULE("LayerRule"),
    SCOPERULE("ScopeRule"),
    STYLERULE("StyleRule");

    private String value;

    CSSRuleType(String value) {
        this.value = value;
    }

    public static CSSRuleType fromString(String s) {
        return java.util.Arrays.stream(CSSRuleType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CSSRuleType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CSSRuleType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
