/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v125.systeminfo.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class GPUDevice {
    private final Number vendorId;
    private final Number deviceId;
    private final Optional<Number> subSysId;
    private final Optional<Number> revision;
    private final String vendorString;
    private final String deviceString;
    private final String driverVendor;
    private final String driverVersion;

    public GPUDevice(Number vendorId, Number deviceId, Optional<Number> subSysId, Optional<Number> revision, String vendorString, String deviceString, String driverVendor, String driverVersion) {
        this.vendorId = Objects.requireNonNull(vendorId, "vendorId is required");
        this.deviceId = Objects.requireNonNull(deviceId, "deviceId is required");
        this.subSysId = subSysId;
        this.revision = revision;
        this.vendorString = Objects.requireNonNull(vendorString, "vendorString is required");
        this.deviceString = Objects.requireNonNull(deviceString, "deviceString is required");
        this.driverVendor = Objects.requireNonNull(driverVendor, "driverVendor is required");
        this.driverVersion = Objects.requireNonNull(driverVersion, "driverVersion is required");
    }

    public Number getVendorId() {
        return this.vendorId;
    }

    public Number getDeviceId() {
        return this.deviceId;
    }

    public Optional<Number> getSubSysId() {
        return this.subSysId;
    }

    public Optional<Number> getRevision() {
        return this.revision;
    }

    public String getVendorString() {
        return this.vendorString;
    }

    public String getDeviceString() {
        return this.deviceString;
    }

    public String getDriverVendor() {
        return this.driverVendor;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    private static GPUDevice fromJson(JsonInput input) {
        Number vendorId = 0;
        Number deviceId = 0;
        Optional<Number> subSysId = Optional.empty();
        Optional<Number> revision = Optional.empty();
        String vendorString = null;
        String deviceString = null;
        String driverVendor = null;
        String driverVersion = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "vendorId": {
                    vendorId = input.nextNumber();
                    continue block20;
                }
                case "deviceId": {
                    deviceId = input.nextNumber();
                    continue block20;
                }
                case "subSysId": {
                    subSysId = Optional.ofNullable(input.nextNumber());
                    continue block20;
                }
                case "revision": {
                    revision = Optional.ofNullable(input.nextNumber());
                    continue block20;
                }
                case "vendorString": {
                    vendorString = input.nextString();
                    continue block20;
                }
                case "deviceString": {
                    deviceString = input.nextString();
                    continue block20;
                }
                case "driverVendor": {
                    driverVendor = input.nextString();
                    continue block20;
                }
                case "driverVersion": {
                    driverVersion = input.nextString();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GPUDevice(vendorId, deviceId, subSysId, revision, vendorString, deviceString, driverVendor, driverVersion);
    }
}

