package org.openqa.selenium.devtools.v121.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when virtual machine parses script. This event is also fired for all known and uncollected
 * scripts upon enabling debugger.
 */
public class ScriptParsed {

    private final org.openqa.selenium.devtools.v121.runtime.model.ScriptId scriptId;

    private final java.lang.String url;

    private final java.lang.Integer startLine;

    private final java.lang.Integer startColumn;

    private final java.lang.Integer endLine;

    private final java.lang.Integer endColumn;

    private final org.openqa.selenium.devtools.v121.runtime.model.ExecutionContextId executionContextId;

    private final java.lang.String hash;

    private final java.util.Optional<java.util.Map<String, Object>> executionContextAuxData;

    private final java.util.Optional<java.lang.Boolean> isLiveEdit;

    private final java.util.Optional<java.lang.String> sourceMapURL;

    private final java.util.Optional<java.lang.Boolean> hasSourceURL;

    private final java.util.Optional<java.lang.Boolean> isModule;

    private final java.util.Optional<java.lang.Integer> length;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.StackTrace> stackTrace;

    private final java.util.Optional<java.lang.Integer> codeOffset;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.ScriptLanguage> scriptLanguage;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.DebugSymbols> debugSymbols;

    private final java.util.Optional<java.lang.String> embedderName;

    public ScriptParsed(org.openqa.selenium.devtools.v121.runtime.model.ScriptId scriptId, java.lang.String url, java.lang.Integer startLine, java.lang.Integer startColumn, java.lang.Integer endLine, java.lang.Integer endColumn, org.openqa.selenium.devtools.v121.runtime.model.ExecutionContextId executionContextId, java.lang.String hash, java.util.Optional<java.util.Map<String, Object>> executionContextAuxData, java.util.Optional<java.lang.Boolean> isLiveEdit, java.util.Optional<java.lang.String> sourceMapURL, java.util.Optional<java.lang.Boolean> hasSourceURL, java.util.Optional<java.lang.Boolean> isModule, java.util.Optional<java.lang.Integer> length, java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.StackTrace> stackTrace, java.util.Optional<java.lang.Integer> codeOffset, java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.ScriptLanguage> scriptLanguage, java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.DebugSymbols> debugSymbols, java.util.Optional<java.lang.String> embedderName) {
        this.scriptId = java.util.Objects.requireNonNull(scriptId, "scriptId is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.startLine = java.util.Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = java.util.Objects.requireNonNull(startColumn, "startColumn is required");
        this.endLine = java.util.Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = java.util.Objects.requireNonNull(endColumn, "endColumn is required");
        this.executionContextId = java.util.Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.hash = java.util.Objects.requireNonNull(hash, "hash is required");
        this.executionContextAuxData = executionContextAuxData;
        this.isLiveEdit = isLiveEdit;
        this.sourceMapURL = sourceMapURL;
        this.hasSourceURL = hasSourceURL;
        this.isModule = isModule;
        this.length = length;
        this.stackTrace = stackTrace;
        this.codeOffset = codeOffset;
        this.scriptLanguage = scriptLanguage;
        this.debugSymbols = debugSymbols;
        this.embedderName = embedderName;
    }

    /**
     * Identifier of the script parsed.
     */
    public org.openqa.selenium.devtools.v121.runtime.model.ScriptId getScriptId() {
        return scriptId;
    }

    /**
     * URL or name of the script parsed (if any).
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Line offset of the script within the resource with given URL (for script tags).
     */
    public java.lang.Integer getStartLine() {
        return startLine;
    }

    /**
     * Column offset of the script within the resource with given URL.
     */
    public java.lang.Integer getStartColumn() {
        return startColumn;
    }

    /**
     * Last line of the script.
     */
    public java.lang.Integer getEndLine() {
        return endLine;
    }

    /**
     * Length of the last line of the script.
     */
    public java.lang.Integer getEndColumn() {
        return endColumn;
    }

    /**
     * Specifies script creation context.
     */
    public org.openqa.selenium.devtools.v121.runtime.model.ExecutionContextId getExecutionContextId() {
        return executionContextId;
    }

    /**
     * Content hash of the script, SHA-256.
     */
    public java.lang.String getHash() {
        return hash;
    }

    /**
     * Embedder-specific auxiliary data likely matching {isDefault: boolean, type: 'default'|'isolated'|'worker', frameId: string}
     */
    public java.util.Optional<java.util.Map<String, Object>> getExecutionContextAuxData() {
        return executionContextAuxData;
    }

    /**
     * True, if this script is generated as a result of the live edit operation.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getIsLiveEdit() {
        return isLiveEdit;
    }

    /**
     * URL of source map associated with script (if any).
     */
    public java.util.Optional<java.lang.String> getSourceMapURL() {
        return sourceMapURL;
    }

    /**
     * True, if this script has sourceURL.
     */
    public java.util.Optional<java.lang.Boolean> getHasSourceURL() {
        return hasSourceURL;
    }

    /**
     * True, if this script is ES6 module.
     */
    public java.util.Optional<java.lang.Boolean> getIsModule() {
        return isModule;
    }

    /**
     * This script length.
     */
    public java.util.Optional<java.lang.Integer> getLength() {
        return length;
    }

    /**
     * JavaScript top stack frame of where the script parsed event was triggered if available.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.StackTrace> getStackTrace() {
        return stackTrace;
    }

    /**
     * If the scriptLanguage is WebAssembly, the code section offset in the module.
     */
    @Beta()
    public java.util.Optional<java.lang.Integer> getCodeOffset() {
        return codeOffset;
    }

    /**
     * The language of the script.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.ScriptLanguage> getScriptLanguage() {
        return scriptLanguage;
    }

    /**
     * If the scriptLanguage is WebASsembly, the source of debug symbols for the module.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.DebugSymbols> getDebugSymbols() {
        return debugSymbols;
    }

    /**
     * The name the embedder supplied for this script.
     */
    @Beta()
    public java.util.Optional<java.lang.String> getEmbedderName() {
        return embedderName;
    }

    private static ScriptParsed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v121.runtime.model.ScriptId scriptId = null;
        java.lang.String url = null;
        java.lang.Integer startLine = 0;
        java.lang.Integer startColumn = 0;
        java.lang.Integer endLine = 0;
        java.lang.Integer endColumn = 0;
        org.openqa.selenium.devtools.v121.runtime.model.ExecutionContextId executionContextId = null;
        java.lang.String hash = null;
        java.util.Optional<java.util.Map<String, Object>> executionContextAuxData = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isLiveEdit = java.util.Optional.empty();
        java.util.Optional<java.lang.String> sourceMapURL = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasSourceURL = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isModule = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> length = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.StackTrace> stackTrace = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> codeOffset = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.ScriptLanguage> scriptLanguage = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.debugger.model.DebugSymbols> debugSymbols = java.util.Optional.empty();
        java.util.Optional<java.lang.String> embedderName = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptId":
                    scriptId = input.read(org.openqa.selenium.devtools.v121.runtime.model.ScriptId.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "startLine":
                    startLine = input.nextNumber().intValue();
                    break;
                case "startColumn":
                    startColumn = input.nextNumber().intValue();
                    break;
                case "endLine":
                    endLine = input.nextNumber().intValue();
                    break;
                case "endColumn":
                    endColumn = input.nextNumber().intValue();
                    break;
                case "executionContextId":
                    executionContextId = input.read(org.openqa.selenium.devtools.v121.runtime.model.ExecutionContextId.class);
                    break;
                case "hash":
                    hash = input.nextString();
                    break;
                case "executionContextAuxData":
                    executionContextAuxData = java.util.Optional.ofNullable((java.util.Map<String, Object>) input.read(java.util.Map.class));
                    break;
                case "isLiveEdit":
                    isLiveEdit = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "sourceMapURL":
                    sourceMapURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "hasSourceURL":
                    hasSourceURL = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "isModule":
                    isModule = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "length":
                    length = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "stackTrace":
                    stackTrace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.runtime.model.StackTrace.class));
                    break;
                case "codeOffset":
                    codeOffset = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "scriptLanguage":
                    scriptLanguage = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.debugger.model.ScriptLanguage.class));
                    break;
                case "debugSymbols":
                    debugSymbols = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.debugger.model.DebugSymbols.class));
                    break;
                case "embedderName":
                    embedderName = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScriptParsed(scriptId, url, startLine, startColumn, endLine, endColumn, executionContextId, hash, executionContextAuxData, isLiveEdit, sourceMapURL, hasSourceURL, isModule, length, stackTrace, codeOffset, scriptLanguage, debugSymbols, embedderName);
    }
}
