package org.openqa.selenium.devtools.v118.fedcm;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the FedCM dialog.
 */
@Beta()
public class FedCm {

    public static Command<Void> enable(java.util.Optional<java.lang.Boolean> disableRejectionDelay) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        disableRejectionDelay.ifPresent(p -> params.put("disableRejectionDelay", p));
        return new Command<>("FedCm.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("FedCm.disable", Map.copyOf(params));
    }

    public static Command<Void> selectAccount(java.lang.String dialogId, java.lang.Integer accountIndex) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        java.util.Objects.requireNonNull(accountIndex, "accountIndex is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        return new Command<>("FedCm.selectAccount", Map.copyOf(params));
    }

    /**
     * Only valid if the dialog type is ConfirmIdpSignin. Acts as if the user had
     * clicked the continue button.
     */
    public static Command<Void> confirmIdpSignin(java.lang.String dialogId) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        return new Command<>("FedCm.confirmIdpSignin", Map.copyOf(params));
    }

    public static Command<Void> dismissDialog(java.lang.String dialogId, java.util.Optional<java.lang.Boolean> triggerCooldown) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        triggerCooldown.ifPresent(p -> params.put("triggerCooldown", p));
        return new Command<>("FedCm.dismissDialog", Map.copyOf(params));
    }

    /**
     * Resets the cooldown time, if any, to allow the next FedCM call to show
     * a dialog even if one was recently dismissed by the user.
     */
    public static Command<Void> resetCooldown() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("FedCm.resetCooldown", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v118.fedcm.model.DialogShown> dialogShown() {
        return new Event<>("FedCm.dialogShown", input -> input.read(org.openqa.selenium.devtools.v118.fedcm.model.DialogShown.class));
    }
}
