package org.openqa.selenium.devtools.v118.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Whether the dialog shown is an account chooser or an auto re-authentication dialog.
 */
public enum DialogType {

    ACCOUNTCHOOSER("AccountChooser"), AUTOREAUTHN("AutoReauthn"), CONFIRMIDPSIGNIN("ConfirmIdpSignin");

    private String value;

    DialogType(String value) {
        this.value = value;
    }

    public static DialogType fromString(String s) {
        return java.util.Arrays.stream(DialogType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DialogType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DialogType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
