package org.openqa.selenium.devtools.v118.security.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details about the security state of the page certificate.
 */
@org.openqa.selenium.Beta()
public class CertificateSecurityState {

    private final java.lang.String protocol;

    private final java.lang.String keyExchange;

    private final java.util.Optional<java.lang.String> keyExchangeGroup;

    private final java.lang.String cipher;

    private final java.util.Optional<java.lang.String> mac;

    private final java.util.List<java.lang.String> certificate;

    private final java.lang.String subjectName;

    private final java.lang.String issuer;

    private final org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validFrom;

    private final org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validTo;

    private final java.util.Optional<java.lang.String> certificateNetworkError;

    private final java.lang.Boolean certificateHasWeakSignature;

    private final java.lang.Boolean certificateHasSha1Signature;

    private final java.lang.Boolean modernSSL;

    private final java.lang.Boolean obsoleteSslProtocol;

    private final java.lang.Boolean obsoleteSslKeyExchange;

    private final java.lang.Boolean obsoleteSslCipher;

    private final java.lang.Boolean obsoleteSslSignature;

    public CertificateSecurityState(java.lang.String protocol, java.lang.String keyExchange, java.util.Optional<java.lang.String> keyExchangeGroup, java.lang.String cipher, java.util.Optional<java.lang.String> mac, java.util.List<java.lang.String> certificate, java.lang.String subjectName, java.lang.String issuer, org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validFrom, org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validTo, java.util.Optional<java.lang.String> certificateNetworkError, java.lang.Boolean certificateHasWeakSignature, java.lang.Boolean certificateHasSha1Signature, java.lang.Boolean modernSSL, java.lang.Boolean obsoleteSslProtocol, java.lang.Boolean obsoleteSslKeyExchange, java.lang.Boolean obsoleteSslCipher, java.lang.Boolean obsoleteSslSignature) {
        this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
        this.keyExchange = java.util.Objects.requireNonNull(keyExchange, "keyExchange is required");
        this.keyExchangeGroup = keyExchangeGroup;
        this.cipher = java.util.Objects.requireNonNull(cipher, "cipher is required");
        this.mac = mac;
        this.certificate = java.util.Objects.requireNonNull(certificate, "certificate is required");
        this.subjectName = java.util.Objects.requireNonNull(subjectName, "subjectName is required");
        this.issuer = java.util.Objects.requireNonNull(issuer, "issuer is required");
        this.validFrom = java.util.Objects.requireNonNull(validFrom, "validFrom is required");
        this.validTo = java.util.Objects.requireNonNull(validTo, "validTo is required");
        this.certificateNetworkError = certificateNetworkError;
        this.certificateHasWeakSignature = java.util.Objects.requireNonNull(certificateHasWeakSignature, "certificateHasWeakSignature is required");
        this.certificateHasSha1Signature = java.util.Objects.requireNonNull(certificateHasSha1Signature, "certificateHasSha1Signature is required");
        this.modernSSL = java.util.Objects.requireNonNull(modernSSL, "modernSSL is required");
        this.obsoleteSslProtocol = java.util.Objects.requireNonNull(obsoleteSslProtocol, "obsoleteSslProtocol is required");
        this.obsoleteSslKeyExchange = java.util.Objects.requireNonNull(obsoleteSslKeyExchange, "obsoleteSslKeyExchange is required");
        this.obsoleteSslCipher = java.util.Objects.requireNonNull(obsoleteSslCipher, "obsoleteSslCipher is required");
        this.obsoleteSslSignature = java.util.Objects.requireNonNull(obsoleteSslSignature, "obsoleteSslSignature is required");
    }

    /**
     * Protocol name (e.g. "TLS 1.2" or "QUIC").
     */
    public java.lang.String getProtocol() {
        return protocol;
    }

    /**
     * Key Exchange used by the connection, or the empty string if not applicable.
     */
    public java.lang.String getKeyExchange() {
        return keyExchange;
    }

    /**
     * (EC)DH group used by the connection, if applicable.
     */
    public java.util.Optional<java.lang.String> getKeyExchangeGroup() {
        return keyExchangeGroup;
    }

    /**
     * Cipher name.
     */
    public java.lang.String getCipher() {
        return cipher;
    }

    /**
     * TLS MAC. Note that AEAD ciphers do not have separate MACs.
     */
    public java.util.Optional<java.lang.String> getMac() {
        return mac;
    }

    /**
     * Page certificate.
     */
    public java.util.List<java.lang.String> getCertificate() {
        return certificate;
    }

    /**
     * Certificate subject name.
     */
    public java.lang.String getSubjectName() {
        return subjectName;
    }

    /**
     * Name of the issuing CA.
     */
    public java.lang.String getIssuer() {
        return issuer;
    }

    /**
     * Certificate valid from date.
     */
    public org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch getValidFrom() {
        return validFrom;
    }

    /**
     * Certificate valid to (expiration) date
     */
    public org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch getValidTo() {
        return validTo;
    }

    /**
     * The highest priority network error code, if the certificate has an error.
     */
    public java.util.Optional<java.lang.String> getCertificateNetworkError() {
        return certificateNetworkError;
    }

    /**
     * True if the certificate uses a weak signature aglorithm.
     */
    public java.lang.Boolean getCertificateHasWeakSignature() {
        return certificateHasWeakSignature;
    }

    /**
     * True if the certificate has a SHA1 signature in the chain.
     */
    public java.lang.Boolean getCertificateHasSha1Signature() {
        return certificateHasSha1Signature;
    }

    /**
     * True if modern SSL
     */
    public java.lang.Boolean getModernSSL() {
        return modernSSL;
    }

    /**
     * True if the connection is using an obsolete SSL protocol.
     */
    public java.lang.Boolean getObsoleteSslProtocol() {
        return obsoleteSslProtocol;
    }

    /**
     * True if the connection is using an obsolete SSL key exchange.
     */
    public java.lang.Boolean getObsoleteSslKeyExchange() {
        return obsoleteSslKeyExchange;
    }

    /**
     * True if the connection is using an obsolete SSL cipher.
     */
    public java.lang.Boolean getObsoleteSslCipher() {
        return obsoleteSslCipher;
    }

    /**
     * True if the connection is using an obsolete SSL signature.
     */
    public java.lang.Boolean getObsoleteSslSignature() {
        return obsoleteSslSignature;
    }

    private static CertificateSecurityState fromJson(JsonInput input) {
        java.lang.String protocol = null;
        java.lang.String keyExchange = null;
        java.util.Optional<java.lang.String> keyExchangeGroup = java.util.Optional.empty();
        java.lang.String cipher = null;
        java.util.Optional<java.lang.String> mac = java.util.Optional.empty();
        java.util.List<java.lang.String> certificate = null;
        java.lang.String subjectName = null;
        java.lang.String issuer = null;
        org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validFrom = null;
        org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch validTo = null;
        java.util.Optional<java.lang.String> certificateNetworkError = java.util.Optional.empty();
        java.lang.Boolean certificateHasWeakSignature = false;
        java.lang.Boolean certificateHasSha1Signature = false;
        java.lang.Boolean modernSSL = false;
        java.lang.Boolean obsoleteSslProtocol = false;
        java.lang.Boolean obsoleteSslKeyExchange = false;
        java.lang.Boolean obsoleteSslCipher = false;
        java.lang.Boolean obsoleteSslSignature = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "protocol":
                    protocol = input.nextString();
                    break;
                case "keyExchange":
                    keyExchange = input.nextString();
                    break;
                case "keyExchangeGroup":
                    keyExchangeGroup = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "cipher":
                    cipher = input.nextString();
                    break;
                case "mac":
                    mac = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "certificate":
                    certificate = input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                    }.getType());
                    break;
                case "subjectName":
                    subjectName = input.nextString();
                    break;
                case "issuer":
                    issuer = input.nextString();
                    break;
                case "validFrom":
                    validFrom = input.read(org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch.class);
                    break;
                case "validTo":
                    validTo = input.read(org.openqa.selenium.devtools.v118.network.model.TimeSinceEpoch.class);
                    break;
                case "certificateNetworkError":
                    certificateNetworkError = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "certificateHasWeakSignature":
                    certificateHasWeakSignature = input.nextBoolean();
                    break;
                case "certificateHasSha1Signature":
                    certificateHasSha1Signature = input.nextBoolean();
                    break;
                case "modernSSL":
                    modernSSL = input.nextBoolean();
                    break;
                case "obsoleteSslProtocol":
                    obsoleteSslProtocol = input.nextBoolean();
                    break;
                case "obsoleteSslKeyExchange":
                    obsoleteSslKeyExchange = input.nextBoolean();
                    break;
                case "obsoleteSslCipher":
                    obsoleteSslCipher = input.nextBoolean();
                    break;
                case "obsoleteSslSignature":
                    obsoleteSslSignature = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CertificateSecurityState(protocol, keyExchange, keyExchangeGroup, cipher, mac, certificate, subjectName, issuer, validFrom, validTo, certificateNetworkError, certificateHasWeakSignature, certificateHasSha1Signature, modernSSL, obsoleteSslProtocol, obsoleteSslKeyExchange, obsoleteSslCipher, obsoleteSslSignature);
    }
}
