package org.openqa.selenium.devtools.v118.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Cookie object
 */
public class Cookie {

    private final java.lang.String name;

    private final java.lang.String value;

    private final java.lang.String domain;

    private final java.lang.String path;

    private final java.lang.Number expires;

    private final java.lang.Integer size;

    private final java.lang.Boolean httpOnly;

    private final java.lang.Boolean secure;

    private final java.lang.Boolean session;

    private final java.util.Optional<org.openqa.selenium.devtools.v118.network.model.CookieSameSite> sameSite;

    private final org.openqa.selenium.devtools.v118.network.model.CookiePriority priority;

    private final java.lang.Boolean sameParty;

    private final org.openqa.selenium.devtools.v118.network.model.CookieSourceScheme sourceScheme;

    private final java.lang.Integer sourcePort;

    private final java.util.Optional<java.lang.String> partitionKey;

    private final java.util.Optional<java.lang.Boolean> partitionKeyOpaque;

    public Cookie(java.lang.String name, java.lang.String value, java.lang.String domain, java.lang.String path, java.lang.Number expires, java.lang.Integer size, java.lang.Boolean httpOnly, java.lang.Boolean secure, java.lang.Boolean session, java.util.Optional<org.openqa.selenium.devtools.v118.network.model.CookieSameSite> sameSite, org.openqa.selenium.devtools.v118.network.model.CookiePriority priority, java.lang.Boolean sameParty, org.openqa.selenium.devtools.v118.network.model.CookieSourceScheme sourceScheme, java.lang.Integer sourcePort, java.util.Optional<java.lang.String> partitionKey, java.util.Optional<java.lang.Boolean> partitionKeyOpaque) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.domain = java.util.Objects.requireNonNull(domain, "domain is required");
        this.path = java.util.Objects.requireNonNull(path, "path is required");
        this.expires = java.util.Objects.requireNonNull(expires, "expires is required");
        this.size = java.util.Objects.requireNonNull(size, "size is required");
        this.httpOnly = java.util.Objects.requireNonNull(httpOnly, "httpOnly is required");
        this.secure = java.util.Objects.requireNonNull(secure, "secure is required");
        this.session = java.util.Objects.requireNonNull(session, "session is required");
        this.sameSite = sameSite;
        this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        this.sameParty = java.util.Objects.requireNonNull(sameParty, "sameParty is required");
        this.sourceScheme = java.util.Objects.requireNonNull(sourceScheme, "sourceScheme is required");
        this.sourcePort = java.util.Objects.requireNonNull(sourcePort, "sourcePort is required");
        this.partitionKey = partitionKey;
        this.partitionKeyOpaque = partitionKeyOpaque;
    }

    /**
     * Cookie name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Cookie value.
     */
    public java.lang.String getValue() {
        return value;
    }

    /**
     * Cookie domain.
     */
    public java.lang.String getDomain() {
        return domain;
    }

    /**
     * Cookie path.
     */
    public java.lang.String getPath() {
        return path;
    }

    /**
     * Cookie expiration date as the number of seconds since the UNIX epoch.
     */
    public java.lang.Number getExpires() {
        return expires;
    }

    /**
     * Cookie size.
     */
    public java.lang.Integer getSize() {
        return size;
    }

    /**
     * True if cookie is http-only.
     */
    public java.lang.Boolean getHttpOnly() {
        return httpOnly;
    }

    /**
     * True if cookie is secure.
     */
    public java.lang.Boolean getSecure() {
        return secure;
    }

    /**
     * True in case of session cookie.
     */
    public java.lang.Boolean getSession() {
        return session;
    }

    /**
     * Cookie SameSite type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v118.network.model.CookieSameSite> getSameSite() {
        return sameSite;
    }

    /**
     * Cookie Priority
     */
    @Beta()
    public org.openqa.selenium.devtools.v118.network.model.CookiePriority getPriority() {
        return priority;
    }

    /**
     * True if cookie is SameParty.
     */
    @Beta()
    public java.lang.Boolean getSameParty() {
        return sameParty;
    }

    /**
     * Cookie source scheme type.
     */
    @Beta()
    public org.openqa.selenium.devtools.v118.network.model.CookieSourceScheme getSourceScheme() {
        return sourceScheme;
    }

    /**
     * Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
     * An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
     * This is a temporary ability and it will be removed in the future.
     */
    @Beta()
    public java.lang.Integer getSourcePort() {
        return sourcePort;
    }

    /**
     * Cookie partition key. The site of the top-level URL the browser was visiting at the start
     * of the request to the endpoint that set the cookie.
     */
    @Beta()
    public java.util.Optional<java.lang.String> getPartitionKey() {
        return partitionKey;
    }

    /**
     * True if cookie partition key is opaque.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getPartitionKeyOpaque() {
        return partitionKeyOpaque;
    }

    private static Cookie fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String value = null;
        java.lang.String domain = null;
        java.lang.String path = null;
        java.lang.Number expires = 0;
        java.lang.Integer size = 0;
        java.lang.Boolean httpOnly = false;
        java.lang.Boolean secure = false;
        java.lang.Boolean session = false;
        java.util.Optional<org.openqa.selenium.devtools.v118.network.model.CookieSameSite> sameSite = java.util.Optional.empty();
        org.openqa.selenium.devtools.v118.network.model.CookiePriority priority = null;
        java.lang.Boolean sameParty = false;
        org.openqa.selenium.devtools.v118.network.model.CookieSourceScheme sourceScheme = null;
        java.lang.Integer sourcePort = 0;
        java.util.Optional<java.lang.String> partitionKey = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> partitionKeyOpaque = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextString();
                    break;
                case "domain":
                    domain = input.nextString();
                    break;
                case "path":
                    path = input.nextString();
                    break;
                case "expires":
                    expires = input.nextNumber();
                    break;
                case "size":
                    size = input.nextNumber().intValue();
                    break;
                case "httpOnly":
                    httpOnly = input.nextBoolean();
                    break;
                case "secure":
                    secure = input.nextBoolean();
                    break;
                case "session":
                    session = input.nextBoolean();
                    break;
                case "sameSite":
                    sameSite = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.network.model.CookieSameSite.class));
                    break;
                case "priority":
                    priority = input.read(org.openqa.selenium.devtools.v118.network.model.CookiePriority.class);
                    break;
                case "sameParty":
                    sameParty = input.nextBoolean();
                    break;
                case "sourceScheme":
                    sourceScheme = input.read(org.openqa.selenium.devtools.v118.network.model.CookieSourceScheme.class);
                    break;
                case "sourcePort":
                    sourcePort = input.nextNumber().intValue();
                    break;
                case "partitionKey":
                    partitionKey = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "partitionKeyOpaque":
                    partitionKeyOpaque = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Cookie(name, value, domain, path, expires, size, httpOnly, secure, session, sameSite, priority, sameParty, sourceScheme, sourcePort, partitionKey, partitionKeyOpaque);
    }
}
