package org.openqa.selenium.devtools.v118.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This information is currently necessary, as the front-end has a difficult
 * time finding a specific cookie. With this, we can convey specific error
 * information without the cookie.
 */
public class CookieIssueDetails {

    private final java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedCookie> cookie;

    private final java.util.Optional<java.lang.String> rawCookieLine;

    private final java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieWarningReason> cookieWarningReasons;

    private final java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieExclusionReason> cookieExclusionReasons;

    private final org.openqa.selenium.devtools.v118.audits.model.CookieOperation operation;

    private final java.util.Optional<java.lang.String> siteForCookies;

    private final java.util.Optional<java.lang.String> cookieUrl;

    private final java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedRequest> request;

    public CookieIssueDetails(java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedCookie> cookie, java.util.Optional<java.lang.String> rawCookieLine, java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieWarningReason> cookieWarningReasons, java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieExclusionReason> cookieExclusionReasons, org.openqa.selenium.devtools.v118.audits.model.CookieOperation operation, java.util.Optional<java.lang.String> siteForCookies, java.util.Optional<java.lang.String> cookieUrl, java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedRequest> request) {
        this.cookie = cookie;
        this.rawCookieLine = rawCookieLine;
        this.cookieWarningReasons = java.util.Objects.requireNonNull(cookieWarningReasons, "cookieWarningReasons is required");
        this.cookieExclusionReasons = java.util.Objects.requireNonNull(cookieExclusionReasons, "cookieExclusionReasons is required");
        this.operation = java.util.Objects.requireNonNull(operation, "operation is required");
        this.siteForCookies = siteForCookies;
        this.cookieUrl = cookieUrl;
        this.request = request;
    }

    /**
     * If AffectedCookie is not set then rawCookieLine contains the raw
     * Set-Cookie header string. This hints at a problem where the
     * cookie line is syntactically or semantically malformed in a way
     * that no valid cookie could be created.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedCookie> getCookie() {
        return cookie;
    }

    public java.util.Optional<java.lang.String> getRawCookieLine() {
        return rawCookieLine;
    }

    public java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieWarningReason> getCookieWarningReasons() {
        return cookieWarningReasons;
    }

    public java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieExclusionReason> getCookieExclusionReasons() {
        return cookieExclusionReasons;
    }

    /**
     * Optionally identifies the site-for-cookies and the cookie url, which
     * may be used by the front-end as additional context.
     */
    public org.openqa.selenium.devtools.v118.audits.model.CookieOperation getOperation() {
        return operation;
    }

    public java.util.Optional<java.lang.String> getSiteForCookies() {
        return siteForCookies;
    }

    public java.util.Optional<java.lang.String> getCookieUrl() {
        return cookieUrl;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    private static CookieIssueDetails fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedCookie> cookie = java.util.Optional.empty();
        java.util.Optional<java.lang.String> rawCookieLine = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieWarningReason> cookieWarningReasons = null;
        java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieExclusionReason> cookieExclusionReasons = null;
        org.openqa.selenium.devtools.v118.audits.model.CookieOperation operation = null;
        java.util.Optional<java.lang.String> siteForCookies = java.util.Optional.empty();
        java.util.Optional<java.lang.String> cookieUrl = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v118.audits.model.AffectedRequest> request = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "cookie":
                    cookie = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.audits.model.AffectedCookie.class));
                    break;
                case "rawCookieLine":
                    rawCookieLine = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "cookieWarningReasons":
                    cookieWarningReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieWarningReason>>() {
                    }.getType());
                    break;
                case "cookieExclusionReasons":
                    cookieExclusionReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v118.audits.model.CookieExclusionReason>>() {
                    }.getType());
                    break;
                case "operation":
                    operation = input.read(org.openqa.selenium.devtools.v118.audits.model.CookieOperation.class);
                    break;
                case "siteForCookies":
                    siteForCookies = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "cookieUrl":
                    cookieUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v118.audits.model.AffectedRequest.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookieIssueDetails(cookie, rawCookieLine, cookieWarningReasons, cookieExclusionReasons, operation, siteForCookies, cookieUrl, request);
    }
}
