/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v117.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v117.network.model.ResourceType;
import org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameResource {
    private final String url;
    private final ResourceType type;
    private final String mimeType;
    private final Optional<TimeSinceEpoch> lastModified;
    private final Optional<Number> contentSize;
    private final Optional<Boolean> failed;
    private final Optional<Boolean> canceled;

    public FrameResource(String url, ResourceType type, String mimeType, Optional<TimeSinceEpoch> lastModified, Optional<Number> contentSize, Optional<Boolean> failed, Optional<Boolean> canceled) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.lastModified = lastModified;
        this.contentSize = contentSize;
        this.failed = failed;
        this.canceled = canceled;
    }

    public String getUrl() {
        return this.url;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Optional<TimeSinceEpoch> getLastModified() {
        return this.lastModified;
    }

    public Optional<Number> getContentSize() {
        return this.contentSize;
    }

    public Optional<Boolean> getFailed() {
        return this.failed;
    }

    public Optional<Boolean> getCanceled() {
        return this.canceled;
    }

    private static FrameResource fromJson(JsonInput input) {
        String url = null;
        ResourceType type = null;
        String mimeType = null;
        Optional<TimeSinceEpoch> lastModified = Optional.empty();
        Optional<Number> contentSize = Optional.empty();
        Optional<Boolean> failed = Optional.empty();
        Optional<Boolean> canceled = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block18;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block18;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block18;
                }
                case "lastModified": {
                    lastModified = Optional.ofNullable((TimeSinceEpoch)input.read(TimeSinceEpoch.class));
                    continue block18;
                }
                case "contentSize": {
                    contentSize = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "failed": {
                    failed = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
                case "canceled": {
                    canceled = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameResource(url, type, mimeType, lastModified, contentSize, failed, canceled);
    }
}

