package org.openqa.selenium.devtools.v117.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The installability error
 */
@org.openqa.selenium.Beta()
public class InstallabilityError {

    private final java.lang.String errorId;

    private final java.util.List<org.openqa.selenium.devtools.v117.page.model.InstallabilityErrorArgument> errorArguments;

    public InstallabilityError(java.lang.String errorId, java.util.List<org.openqa.selenium.devtools.v117.page.model.InstallabilityErrorArgument> errorArguments) {
        this.errorId = java.util.Objects.requireNonNull(errorId, "errorId is required");
        this.errorArguments = java.util.Objects.requireNonNull(errorArguments, "errorArguments is required");
    }

    /**
     * The error id (e.g. 'manifest-missing-suitable-icon').
     */
    public java.lang.String getErrorId() {
        return errorId;
    }

    /**
     * The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).
     */
    public java.util.List<org.openqa.selenium.devtools.v117.page.model.InstallabilityErrorArgument> getErrorArguments() {
        return errorArguments;
    }

    private static InstallabilityError fromJson(JsonInput input) {
        java.lang.String errorId = null;
        java.util.List<org.openqa.selenium.devtools.v117.page.model.InstallabilityErrorArgument> errorArguments = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "errorId":
                    errorId = input.nextString();
                    break;
                case "errorArguments":
                    errorArguments = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v117.page.model.InstallabilityErrorArgument>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InstallabilityError(errorId, errorArguments);
    }
}
