package org.openqa.selenium.devtools.v117.autofill;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines commands and events for Autofill.
 */
@Beta()
public class Autofill {

    /**
     * Trigger autofill on a form identified by the fieldId.
     * If the field and related form cannot be autofilled, returns an error.
     */
    public static Command<Void> trigger(org.openqa.selenium.devtools.v117.dom.model.BackendNodeId fieldId, java.util.Optional<org.openqa.selenium.devtools.v117.page.model.FrameId> frameId, org.openqa.selenium.devtools.v117.autofill.model.CreditCard card) {
        java.util.Objects.requireNonNull(fieldId, "fieldId is required");
        java.util.Objects.requireNonNull(card, "card is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("fieldId", fieldId);
        frameId.ifPresent(p -> params.put("frameId", p));
        params.put("card", card);
        return new Command<>("Autofill.trigger", params.build());
    }

    /**
     * Set addresses so that developers can verify their forms implementation.
     */
    public static Command<Void> setAddresses(java.util.List<org.openqa.selenium.devtools.v117.autofill.model.Address> addresses) {
        java.util.Objects.requireNonNull(addresses, "addresses is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("addresses", addresses);
        return new Command<>("Autofill.setAddresses", params.build());
    }
}
