/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.accessibility.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum AXPropertyName {
    BUSY("busy"),
    DISABLED("disabled"),
    EDITABLE("editable"),
    FOCUSABLE("focusable"),
    FOCUSED("focused"),
    HIDDEN("hidden"),
    HIDDENROOT("hiddenRoot"),
    INVALID("invalid"),
    KEYSHORTCUTS("keyshortcuts"),
    SETTABLE("settable"),
    ROLEDESCRIPTION("roledescription"),
    LIVE("live"),
    ATOMIC("atomic"),
    RELEVANT("relevant"),
    ROOT("root"),
    AUTOCOMPLETE("autocomplete"),
    HASPOPUP("hasPopup"),
    LEVEL("level"),
    MULTISELECTABLE("multiselectable"),
    ORIENTATION("orientation"),
    MULTILINE("multiline"),
    READONLY("readonly"),
    REQUIRED("required"),
    VALUEMIN("valuemin"),
    VALUEMAX("valuemax"),
    VALUETEXT("valuetext"),
    CHECKED("checked"),
    EXPANDED("expanded"),
    MODAL("modal"),
    PRESSED("pressed"),
    SELECTED("selected"),
    ACTIVEDESCENDANT("activedescendant"),
    CONTROLS("controls"),
    DESCRIBEDBY("describedby"),
    DETAILS("details"),
    ERRORMESSAGE("errormessage"),
    FLOWTO("flowto"),
    LABELLEDBY("labelledby"),
    OWNS("owns");

    private String value;

    private AXPropertyName(String value) {
        this.value = value;
    }

    public static AXPropertyName fromString(String s) {
        return Arrays.stream(AXPropertyName.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within AXPropertyName "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AXPropertyName fromJson(JsonInput input) {
        return AXPropertyName.fromString(input.nextString());
    }
}

