package org.openqa.selenium.devtools.v116.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for issues around "Attribution Reporting API" usage.
 * Explainer: https://github.com/WICG/attribution-reporting-api
 */
public class AttributionReportingIssueDetails {

    private final org.openqa.selenium.devtools.v116.audits.model.AttributionReportingIssueType violationType;

    private final java.util.Optional<org.openqa.selenium.devtools.v116.audits.model.AffectedRequest> request;

    private final java.util.Optional<org.openqa.selenium.devtools.v116.dom.model.BackendNodeId> violatingNodeId;

    private final java.util.Optional<java.lang.String> invalidParameter;

    public AttributionReportingIssueDetails(org.openqa.selenium.devtools.v116.audits.model.AttributionReportingIssueType violationType, java.util.Optional<org.openqa.selenium.devtools.v116.audits.model.AffectedRequest> request, java.util.Optional<org.openqa.selenium.devtools.v116.dom.model.BackendNodeId> violatingNodeId, java.util.Optional<java.lang.String> invalidParameter) {
        this.violationType = java.util.Objects.requireNonNull(violationType, "violationType is required");
        this.request = request;
        this.violatingNodeId = violatingNodeId;
        this.invalidParameter = invalidParameter;
    }

    public org.openqa.selenium.devtools.v116.audits.model.AttributionReportingIssueType getViolationType() {
        return violationType;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v116.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v116.dom.model.BackendNodeId> getViolatingNodeId() {
        return violatingNodeId;
    }

    public java.util.Optional<java.lang.String> getInvalidParameter() {
        return invalidParameter;
    }

    private static AttributionReportingIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v116.audits.model.AttributionReportingIssueType violationType = null;
        java.util.Optional<org.openqa.selenium.devtools.v116.audits.model.AffectedRequest> request = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v116.dom.model.BackendNodeId> violatingNodeId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> invalidParameter = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "violationType":
                    violationType = input.read(org.openqa.selenium.devtools.v116.audits.model.AttributionReportingIssueType.class);
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v116.audits.model.AffectedRequest.class));
                    break;
                case "violatingNodeId":
                    violatingNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v116.dom.model.BackendNodeId.class));
                    break;
                case "invalidParameter":
                    invalidParameter = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingIssueDetails(violationType, request, violatingNodeId, invalidParameter);
    }
}
