/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.dom.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum PseudoType {
    FIRST_LINE("first-line"),
    FIRST_LETTER("first-letter"),
    BEFORE("before"),
    AFTER("after"),
    MARKER("marker"),
    BACKDROP("backdrop"),
    SELECTION("selection"),
    TARGET_TEXT("target-text"),
    SPELLING_ERROR("spelling-error"),
    GRAMMAR_ERROR("grammar-error"),
    HIGHLIGHT("highlight"),
    FIRST_LINE_INHERITED("first-line-inherited"),
    SCROLLBAR("scrollbar"),
    SCROLLBAR_THUMB("scrollbar-thumb"),
    SCROLLBAR_BUTTON("scrollbar-button"),
    SCROLLBAR_TRACK("scrollbar-track"),
    SCROLLBAR_TRACK_PIECE("scrollbar-track-piece"),
    SCROLLBAR_CORNER("scrollbar-corner"),
    RESIZER("resizer"),
    INPUT_LIST_BUTTON("input-list-button"),
    VIEW_TRANSITION("view-transition"),
    VIEW_TRANSITION_GROUP("view-transition-group"),
    VIEW_TRANSITION_IMAGE_PAIR("view-transition-image-pair"),
    VIEW_TRANSITION_OLD("view-transition-old"),
    VIEW_TRANSITION_NEW("view-transition-new");

    private String value;

    private PseudoType(String value) {
        this.value = value;
    }

    public static PseudoType fromString(String s) {
        return Arrays.stream(PseudoType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PseudoType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PseudoType fromJson(JsonInput input) {
        return PseudoType.fromString(input.nextString());
    }
}

