/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum CookieOperation {
    SETCOOKIE("SetCookie"),
    READCOOKIE("ReadCookie");

    private String value;

    private CookieOperation(String value) {
        this.value = value;
    }

    public static CookieOperation fromString(String s) {
        return Arrays.stream(CookieOperation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CookieOperation "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieOperation fromJson(JsonInput input) {
        return CookieOperation.fromString(input.nextString());
    }
}

