package org.openqa.selenium.devtools.v115.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for an origin's shared storage.
 */
public class SharedStorageMetadata {

    private final org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch creationTime;

    private final java.lang.Integer length;

    private final java.lang.Number remainingBudget;

    public SharedStorageMetadata(org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch creationTime, java.lang.Integer length, java.lang.Number remainingBudget) {
        this.creationTime = java.util.Objects.requireNonNull(creationTime, "creationTime is required");
        this.length = java.util.Objects.requireNonNull(length, "length is required");
        this.remainingBudget = java.util.Objects.requireNonNull(remainingBudget, "remainingBudget is required");
    }

    public org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch getCreationTime() {
        return creationTime;
    }

    public java.lang.Integer getLength() {
        return length;
    }

    public java.lang.Number getRemainingBudget() {
        return remainingBudget;
    }

    private static SharedStorageMetadata fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch creationTime = null;
        java.lang.Integer length = 0;
        java.lang.Number remainingBudget = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "creationTime":
                    creationTime = input.read(org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch.class);
                    break;
                case "length":
                    length = input.nextNumber().intValue();
                    break;
                case "remainingBudget":
                    remainingBudget = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageMetadata(creationTime, length, remainingBudget);
    }
}
