package org.openqa.selenium.devtools.v115.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a preload enabled state is updated.
 */
public class PreloadEnabledStateUpdated {

    private final java.lang.Boolean disabledByPreference;

    private final java.lang.Boolean disabledByDataSaver;

    private final java.lang.Boolean disabledByBatterySaver;

    public PreloadEnabledStateUpdated(java.lang.Boolean disabledByPreference, java.lang.Boolean disabledByDataSaver, java.lang.Boolean disabledByBatterySaver) {
        this.disabledByPreference = java.util.Objects.requireNonNull(disabledByPreference, "disabledByPreference is required");
        this.disabledByDataSaver = java.util.Objects.requireNonNull(disabledByDataSaver, "disabledByDataSaver is required");
        this.disabledByBatterySaver = java.util.Objects.requireNonNull(disabledByBatterySaver, "disabledByBatterySaver is required");
    }

    public java.lang.Boolean getDisabledByPreference() {
        return disabledByPreference;
    }

    public java.lang.Boolean getDisabledByDataSaver() {
        return disabledByDataSaver;
    }

    public java.lang.Boolean getDisabledByBatterySaver() {
        return disabledByBatterySaver;
    }

    private static PreloadEnabledStateUpdated fromJson(JsonInput input) {
        java.lang.Boolean disabledByPreference = false;
        java.lang.Boolean disabledByDataSaver = false;
        java.lang.Boolean disabledByBatterySaver = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "disabledByPreference":
                    disabledByPreference = input.nextBoolean();
                    break;
                case "disabledByDataSaver":
                    disabledByDataSaver = input.nextBoolean();
                    break;
                case "disabledByBatterySaver":
                    disabledByBatterySaver = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreloadEnabledStateUpdated(disabledByPreference, disabledByDataSaver, disabledByBatterySaver);
    }
}
