/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v113.audits.model.GenericIssueErrorType;
import org.openqa.selenium.devtools.v113.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v113.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class GenericIssueDetails {
    private final GenericIssueErrorType errorType;
    private final Optional<FrameId> frameId;
    private final Optional<BackendNodeId> violatingNodeId;

    public GenericIssueDetails(GenericIssueErrorType errorType, Optional<FrameId> frameId, Optional<BackendNodeId> violatingNodeId) {
        this.errorType = Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
        this.violatingNodeId = violatingNodeId;
    }

    public GenericIssueErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        GenericIssueErrorType errorType = null;
        Optional<FrameId> frameId = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorType": {
                    errorType = (GenericIssueErrorType)((Object)input.read(GenericIssueErrorType.class));
                    continue block10;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block10;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId, violatingNodeId);
    }
}

