package org.openqa.selenium.devtools.v113.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to SpeculationRuleSet
 */
public class RuleSet {

    private final org.openqa.selenium.devtools.v113.preload.model.RuleSetId id;

    private final org.openqa.selenium.devtools.v113.network.model.LoaderId loaderId;

    private final java.lang.String sourceText;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType> errorType;

    private final java.util.Optional<java.lang.String> errorMessage;

    public RuleSet(org.openqa.selenium.devtools.v113.preload.model.RuleSetId id, org.openqa.selenium.devtools.v113.network.model.LoaderId loaderId, java.lang.String sourceText, java.util.Optional<org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType> errorType, java.util.Optional<java.lang.String> errorMessage) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = java.util.Objects.requireNonNull(sourceText, "sourceText is required");
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    public org.openqa.selenium.devtools.v113.preload.model.RuleSetId getId() {
        return id;
    }

    /**
     * Identifies a document which the rule set is associated with.
     */
    public org.openqa.selenium.devtools.v113.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    /**
     * Source text of JSON representing the rule set. If it comes from
     * `script` tag, it is the textContent of the node. Note that it is
     * a JSON for valid case.
     *
     * See also:
     * - https://wicg.github.io/nav-speculation/speculation-rules.html
     * - https://github.com/WICG/nav-speculation/blob/main/triggers.md
     */
    public java.lang.String getSourceText() {
        return sourceText;
    }

    /**
     * Error information
     * `errorMessage` is null iff `errorType` is null.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType> getErrorType() {
        return errorType;
    }

    /**
     * TODO(https://crbug.com/1425354): Replace this property with structured error.
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getErrorMessage() {
        return errorMessage;
    }

    private static RuleSet fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v113.preload.model.RuleSetId id = null;
        org.openqa.selenium.devtools.v113.network.model.LoaderId loaderId = null;
        java.lang.String sourceText = null;
        java.util.Optional<org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType> errorType = java.util.Optional.empty();
        java.util.Optional<java.lang.String> errorMessage = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v113.preload.model.RuleSetId.class);
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v113.network.model.LoaderId.class);
                    break;
                case "sourceText":
                    sourceText = input.nextString();
                    break;
                case "errorType":
                    errorType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType.class));
                    break;
                case "errorMessage":
                    errorMessage = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText, errorType, errorMessage);
    }
}
