package org.openqa.selenium.devtools.v113.log.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Log entry.
 */
public class LogEntry {

    public enum Source {

        XML("xml"),
        JAVASCRIPT("javascript"),
        NETWORK("network"),
        STORAGE("storage"),
        APPCACHE("appcache"),
        RENDERING("rendering"),
        SECURITY("security"),
        DEPRECATION("deprecation"),
        WORKER("worker"),
        VIOLATION("violation"),
        INTERVENTION("intervention"),
        RECOMMENDATION("recommendation"),
        OTHER("other");

        private String value;

        Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return java.util.Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Source fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    public enum Level {

        VERBOSE("verbose"), INFO("info"), WARNING("warning"), ERROR("error");

        private String value;

        Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s) {
            return java.util.Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Level "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Level fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    public enum Category {

        CORS("cors");

        private String value;

        Category(String value) {
            this.value = value;
        }

        public static Category fromString(String s) {
            return java.util.Arrays.stream(Category.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Category "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Category fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Source source;

    private final Level level;

    private final java.lang.String text;

    private final java.util.Optional<Category> category;

    private final org.openqa.selenium.devtools.v113.runtime.model.Timestamp timestamp;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<java.lang.Integer> lineNumber;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.runtime.model.StackTrace> stackTrace;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.network.model.RequestId> networkRequestId;

    private final java.util.Optional<java.lang.String> workerId;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v113.runtime.model.RemoteObject>> args;

    public LogEntry(Source source, Level level, java.lang.String text, java.util.Optional<Category> category, org.openqa.selenium.devtools.v113.runtime.model.Timestamp timestamp, java.util.Optional<java.lang.String> url, java.util.Optional<java.lang.Integer> lineNumber, java.util.Optional<org.openqa.selenium.devtools.v113.runtime.model.StackTrace> stackTrace, java.util.Optional<org.openqa.selenium.devtools.v113.network.model.RequestId> networkRequestId, java.util.Optional<java.lang.String> workerId, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v113.runtime.model.RemoteObject>> args) {
        this.source = java.util.Objects.requireNonNull(source, "source is required");
        this.level = java.util.Objects.requireNonNull(level, "level is required");
        this.text = java.util.Objects.requireNonNull(text, "text is required");
        this.category = category;
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.url = url;
        this.lineNumber = lineNumber;
        this.stackTrace = stackTrace;
        this.networkRequestId = networkRequestId;
        this.workerId = workerId;
        this.args = args;
    }

    /**
     * Log entry source.
     */
    public Source getSource() {
        return source;
    }

    /**
     * Log entry severity.
     */
    public Level getLevel() {
        return level;
    }

    /**
     * Logged text.
     */
    public java.lang.String getText() {
        return text;
    }

    public java.util.Optional<Category> getCategory() {
        return category;
    }

    /**
     * Timestamp when this entry was added.
     */
    public org.openqa.selenium.devtools.v113.runtime.model.Timestamp getTimestamp() {
        return timestamp;
    }

    /**
     * URL of the resource if known.
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    /**
     * Line number in the resource.
     */
    public java.util.Optional<java.lang.Integer> getLineNumber() {
        return lineNumber;
    }

    /**
     * JavaScript stack trace.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.runtime.model.StackTrace> getStackTrace() {
        return stackTrace;
    }

    /**
     * Identifier of the network request associated with this entry.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.network.model.RequestId> getNetworkRequestId() {
        return networkRequestId;
    }

    /**
     * Identifier of the worker associated with this entry.
     */
    public java.util.Optional<java.lang.String> getWorkerId() {
        return workerId;
    }

    /**
     * Call arguments.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v113.runtime.model.RemoteObject>> getArgs() {
        return args;
    }

    private static LogEntry fromJson(JsonInput input) {
        Source source = null;
        Level level = null;
        java.lang.String text = null;
        java.util.Optional<Category> category = java.util.Optional.empty();
        org.openqa.selenium.devtools.v113.runtime.model.Timestamp timestamp = null;
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> lineNumber = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.runtime.model.StackTrace> stackTrace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.network.model.RequestId> networkRequestId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> workerId = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v113.runtime.model.RemoteObject>> args = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "source":
                    source = Source.fromString(input.nextString());
                    break;
                case "level":
                    level = Level.fromString(input.nextString());
                    break;
                case "text":
                    text = input.nextString();
                    break;
                case "category":
                    category = java.util.Optional.ofNullable(Category.fromString(input.nextString()));
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v113.runtime.model.Timestamp.class);
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "lineNumber":
                    lineNumber = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "stackTrace":
                    stackTrace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.runtime.model.StackTrace.class));
                    break;
                case "networkRequestId":
                    networkRequestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.network.model.RequestId.class));
                    break;
                case "workerId":
                    workerId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "args":
                    args = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v113.runtime.model.RemoteObject>>() {
                    }.getType()));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LogEntry(source, level, text, category, timestamp, url, lineNumber, stackTrace, networkRequestId, workerId, args);
    }
}
