package org.openqa.selenium.devtools.v112.storage;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Storage {

    /**
     * Returns a storage key given a frame id.
     */
    public static Command<org.openqa.selenium.devtools.v112.storage.model.SerializedStorageKey> getStorageKeyForFrame(org.openqa.selenium.devtools.v112.page.model.FrameId frameId) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        return new Command<>("Storage.getStorageKeyForFrame", params.build(), ConverterFunctions.map("storageKey", org.openqa.selenium.devtools.v112.storage.model.SerializedStorageKey.class));
    }

    /**
     * Clears storage for origin.
     */
    public static Command<Void> clearDataForOrigin(java.lang.String origin, java.lang.String storageTypes) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        java.util.Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<>("Storage.clearDataForOrigin", params.build());
    }

    /**
     * Clears storage for storage key.
     */
    public static Command<Void> clearDataForStorageKey(java.lang.String storageKey, java.lang.String storageTypes) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        java.util.Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        params.put("storageTypes", storageTypes);
        return new Command<>("Storage.clearDataForStorageKey", params.build());
    }

    /**
     * Returns all browser cookies.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v112.network.model.Cookie>> getCookies(java.util.Optional<org.openqa.selenium.devtools.v112.browser.model.BrowserContextID> browserContextId) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.getCookies", params.build(), ConverterFunctions.map("cookies", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.network.model.Cookie>>() {
        }.getType()));
    }

    /**
     * Sets given cookies.
     */
    public static Command<Void> setCookies(java.util.List<org.openqa.selenium.devtools.v112.network.model.CookieParam> cookies, java.util.Optional<org.openqa.selenium.devtools.v112.browser.model.BrowserContextID> browserContextId) {
        java.util.Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.setCookies", params.build());
    }

    /**
     * Clears cookies.
     */
    public static Command<Void> clearCookies(java.util.Optional<org.openqa.selenium.devtools.v112.browser.model.BrowserContextID> browserContextId) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.clearCookies", params.build());
    }

    public static class GetUsageAndQuotaResponse {

        private final java.lang.Number usage;

        private final java.lang.Number quota;

        private final java.lang.Boolean overrideActive;

        private final java.util.List<org.openqa.selenium.devtools.v112.storage.model.UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(java.lang.Number usage, java.lang.Number quota, java.lang.Boolean overrideActive, java.util.List<org.openqa.selenium.devtools.v112.storage.model.UsageForType> usageBreakdown) {
            this.usage = java.util.Objects.requireNonNull(usage, "usage is required");
            this.quota = java.util.Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = java.util.Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = java.util.Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        /**
         * Storage usage (bytes).
         */
        public java.lang.Number getUsage() {
            return usage;
        }

        /**
         * Storage quota (bytes).
         */
        public java.lang.Number getQuota() {
            return quota;
        }

        /**
         * Whether or not the origin has an active storage quota override
         */
        public java.lang.Boolean getOverrideActive() {
            return overrideActive;
        }

        /**
         * Storage usage per type (bytes).
         */
        public java.util.List<org.openqa.selenium.devtools.v112.storage.model.UsageForType> getUsageBreakdown() {
            return usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            java.lang.Number usage = 0;
            java.lang.Number quota = 0;
            java.lang.Boolean overrideActive = false;
            java.util.List<org.openqa.selenium.devtools.v112.storage.model.UsageForType> usageBreakdown = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "usage":
                        usage = input.nextNumber();
                        break;
                    case "quota":
                        quota = input.nextNumber();
                        break;
                    case "overrideActive":
                        overrideActive = input.nextBoolean();
                        break;
                    case "usageBreakdown":
                        usageBreakdown = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.storage.model.UsageForType>>() {
                        }.getType());
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }

    /**
     * Returns usage and quota in bytes.
     */
    public static Command<org.openqa.selenium.devtools.v112.storage.Storage.GetUsageAndQuotaResponse> getUsageAndQuota(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<>("Storage.getUsageAndQuota", params.build(), input -> input.read(org.openqa.selenium.devtools.v112.storage.Storage.GetUsageAndQuotaResponse.class));
    }

    /**
     * Override quota for the specified origin
     */
    @Beta()
    public static Command<Void> overrideQuotaForOrigin(java.lang.String origin, java.util.Optional<java.lang.Number> quotaSize) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", p));
        return new Command<>("Storage.overrideQuotaForOrigin", params.build());
    }

    /**
     * Registers origin to be notified when an update occurs to its cache storage list.
     */
    public static Command<Void> trackCacheStorageForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<>("Storage.trackCacheStorageForOrigin", params.build());
    }

    /**
     * Registers storage key to be notified when an update occurs to its cache storage list.
     */
    public static Command<Void> trackCacheStorageForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.trackCacheStorageForStorageKey", params.build());
    }

    /**
     * Registers origin to be notified when an update occurs to its IndexedDB.
     */
    public static Command<Void> trackIndexedDBForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<>("Storage.trackIndexedDBForOrigin", params.build());
    }

    /**
     * Registers storage key to be notified when an update occurs to its IndexedDB.
     */
    public static Command<Void> trackIndexedDBForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.trackIndexedDBForStorageKey", params.build());
    }

    /**
     * Unregisters origin from receiving notifications for cache storage.
     */
    public static Command<Void> untrackCacheStorageForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<>("Storage.untrackCacheStorageForOrigin", params.build());
    }

    /**
     * Unregisters storage key from receiving notifications for cache storage.
     */
    public static Command<Void> untrackCacheStorageForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.untrackCacheStorageForStorageKey", params.build());
    }

    /**
     * Unregisters origin from receiving notifications for IndexedDB.
     */
    public static Command<Void> untrackIndexedDBForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<>("Storage.untrackIndexedDBForOrigin", params.build());
    }

    /**
     * Unregisters storage key from receiving notifications for IndexedDB.
     */
    public static Command<Void> untrackIndexedDBForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.untrackIndexedDBForStorageKey", params.build());
    }

    /**
     * Returns the number of stored Trust Tokens per issuer for the
     * current browsing context.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v112.storage.model.TrustTokens>> getTrustTokens() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Storage.getTrustTokens", params.build(), ConverterFunctions.map("tokens", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.storage.model.TrustTokens>>() {
        }.getType()));
    }

    /**
     * Removes all Trust Tokens issued by the provided issuerOrigin.
     * Leaves other stored data, including the issuer's Redemption Records, intact.
     */
    @Beta()
    public static Command<java.lang.Boolean> clearTrustTokens(java.lang.String issuerOrigin) {
        java.util.Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("issuerOrigin", issuerOrigin);
        return new Command<>("Storage.clearTrustTokens", params.build(), ConverterFunctions.map("didDeleteTokens", java.lang.Boolean.class));
    }

    /**
     * Gets details for a named interest group.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v112.storage.model.InterestGroupDetails> getInterestGroupDetails(java.lang.String ownerOrigin, java.lang.String name) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("name", name);
        return new Command<>("Storage.getInterestGroupDetails", params.build(), ConverterFunctions.map("details", org.openqa.selenium.devtools.v112.storage.model.InterestGroupDetails.class));
    }

    /**
     * Enables/Disables issuing of interestGroupAccessed events.
     */
    @Beta()
    public static Command<Void> setInterestGroupTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<>("Storage.setInterestGroupTracking", params.build());
    }

    /**
     * Gets metadata for an origin's shared storage.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v112.storage.model.SharedStorageMetadata> getSharedStorageMetadata(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.getSharedStorageMetadata", params.build(), ConverterFunctions.map("metadata", org.openqa.selenium.devtools.v112.storage.model.SharedStorageMetadata.class));
    }

    /**
     * Gets the entries in an given origin's shared storage.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v112.storage.model.SharedStorageEntry>> getSharedStorageEntries(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.getSharedStorageEntries", params.build(), ConverterFunctions.map("entries", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.storage.model.SharedStorageEntry>>() {
        }.getType()));
    }

    /**
     * Sets entry with `key` and `value` for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> setSharedStorageEntry(java.lang.String ownerOrigin, java.lang.String key, java.lang.String value, java.util.Optional<java.lang.Boolean> ignoreIfPresent) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(key, "key is required");
        java.util.Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        params.put("value", value);
        ignoreIfPresent.ifPresent(p -> params.put("ignoreIfPresent", p));
        return new Command<>("Storage.setSharedStorageEntry", params.build());
    }

    /**
     * Deletes entry for `key` (if it exists) for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> deleteSharedStorageEntry(java.lang.String ownerOrigin, java.lang.String key) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(key, "key is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        return new Command<>("Storage.deleteSharedStorageEntry", params.build());
    }

    /**
     * Clears all entries for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> clearSharedStorageEntries(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.clearSharedStorageEntries", params.build());
    }

    /**
     * Resets the budget for `ownerOrigin` by clearing all budget withdrawals.
     */
    @Beta()
    public static Command<Void> resetSharedStorageBudget(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.resetSharedStorageBudget", params.build());
    }

    /**
     * Enables/disables issuing of sharedStorageAccessed events.
     */
    @Beta()
    public static Command<Void> setSharedStorageTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<>("Storage.setSharedStorageTracking", params.build());
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<>("Storage.cacheStorageContentUpdated", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.CacheStorageContentUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event<>("Storage.cacheStorageListUpdated", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.CacheStorageListUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<>("Storage.indexedDBContentUpdated", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.IndexedDBContentUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event<>("Storage.indexedDBListUpdated", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.IndexedDBListUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.InterestGroupAccessed> interestGroupAccessed() {
        return new Event<>("Storage.interestGroupAccessed", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.InterestGroupAccessed.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.storage.model.SharedStorageAccessed> sharedStorageAccessed() {
        return new Event<>("Storage.sharedStorageAccessed", input -> input.read(org.openqa.selenium.devtools.v112.storage.model.SharedStorageAccessed.class));
    }
}
