package org.openqa.selenium.devtools.v112.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Preloading status values, see also PreloadingTriggeringOutcome. This
 * status is shared by prefetchStatusUpdated and prerenderStatusUpdated.
 */
public enum PreloadingStatus {

    PENDING("Pending"),
    RUNNING("Running"),
    READY("Ready"),
    SUCCESS("Success"),
    FAILURE("Failure"),
    NOTSUPPORTED("NotSupported");

    private String value;

    PreloadingStatus(String value) {
        this.value = value;
    }

    public static PreloadingStatus fromString(String s) {
        return java.util.Arrays.stream(PreloadingStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PreloadingStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PreloadingStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
