/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v111.network.model.BlockedReason;
import org.openqa.selenium.devtools.v111.network.model.CorsErrorStatus;
import org.openqa.selenium.devtools.v111.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v111.network.model.RequestId;
import org.openqa.selenium.devtools.v111.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

public class LoadingFailed {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final String errorText;
    private final Optional<Boolean> canceled;
    private final Optional<BlockedReason> blockedReason;
    private final Optional<CorsErrorStatus> corsErrorStatus;

    public LoadingFailed(RequestId requestId, MonotonicTime timestamp, ResourceType type, String errorText, Optional<Boolean> canceled, Optional<BlockedReason> blockedReason, Optional<CorsErrorStatus> corsErrorStatus) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.errorText = Objects.requireNonNull(errorText, "errorText is required");
        this.canceled = canceled;
        this.blockedReason = blockedReason;
        this.corsErrorStatus = corsErrorStatus;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public Optional<Boolean> getCanceled() {
        return this.canceled;
    }

    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    public Optional<CorsErrorStatus> getCorsErrorStatus() {
        return this.corsErrorStatus;
    }

    private static LoadingFailed fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        ResourceType type = null;
        String errorText = null;
        Optional<Boolean> canceled = Optional.empty();
        Optional<BlockedReason> blockedReason = Optional.empty();
        Optional<CorsErrorStatus> corsErrorStatus = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block18;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block18;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block18;
                }
                case "errorText": {
                    errorText = input.nextString();
                    continue block18;
                }
                case "canceled": {
                    canceled = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
                case "blockedReason": {
                    blockedReason = Optional.ofNullable((BlockedReason)((Object)input.read(BlockedReason.class)));
                    continue block18;
                }
                case "corsErrorStatus": {
                    corsErrorStatus = Optional.ofNullable((CorsErrorStatus)input.read(CorsErrorStatus.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadingFailed(requestId, timestamp, type, errorText, canceled, blockedReason, corsErrorStatus);
    }
}

