package org.openqa.selenium.devtools.v111.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Depending on the concrete errorType, different properties are set.
 */
public class GenericIssueDetails {

    private final org.openqa.selenium.devtools.v111.audits.model.GenericIssueErrorType errorType;

    private final java.util.Optional<org.openqa.selenium.devtools.v111.page.model.FrameId> frameId;

    private final java.util.Optional<org.openqa.selenium.devtools.v111.dom.model.BackendNodeId> violatingNodeId;

    public GenericIssueDetails(org.openqa.selenium.devtools.v111.audits.model.GenericIssueErrorType errorType, java.util.Optional<org.openqa.selenium.devtools.v111.page.model.FrameId> frameId, java.util.Optional<org.openqa.selenium.devtools.v111.dom.model.BackendNodeId> violatingNodeId) {
        this.errorType = java.util.Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
        this.violatingNodeId = violatingNodeId;
    }

    /**
     * Issues with the same errorType are aggregated in the frontend.
     */
    public org.openqa.selenium.devtools.v111.audits.model.GenericIssueErrorType getErrorType() {
        return errorType;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v111.page.model.FrameId> getFrameId() {
        return frameId;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v111.dom.model.BackendNodeId> getViolatingNodeId() {
        return violatingNodeId;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v111.audits.model.GenericIssueErrorType errorType = null;
        java.util.Optional<org.openqa.selenium.devtools.v111.page.model.FrameId> frameId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v111.dom.model.BackendNodeId> violatingNodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "errorType":
                    errorType = input.read(org.openqa.selenium.devtools.v111.audits.model.GenericIssueErrorType.class);
                    break;
                case "frameId":
                    frameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v111.page.model.FrameId.class));
                    break;
                case "violatingNodeId":
                    violatingNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v111.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId, violatingNodeId);
    }
}
