package org.openqa.selenium.devtools.v110.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the failure reason when a federated authentication reason fails.
 * Should be updated alongside RequestIdTokenStatus in
 * third_party/blink/public/mojom/devtools/inspector_issue.mojom to include
 * all cases except for success.
 */
public enum FederatedAuthRequestIssueReason {

    SHOULDEMBARGO("ShouldEmbargo"),
    TOOMANYREQUESTS("TooManyRequests"),
    WELLKNOWNHTTPNOTFOUND("WellKnownHttpNotFound"),
    WELLKNOWNNORESPONSE("WellKnownNoResponse"),
    WELLKNOWNINVALIDRESPONSE("WellKnownInvalidResponse"),
    CONFIGNOTINWELLKNOWN("ConfigNotInWellKnown"),
    WELLKNOWNTOOBIG("WellKnownTooBig"),
    CONFIGHTTPNOTFOUND("ConfigHttpNotFound"),
    CONFIGNORESPONSE("ConfigNoResponse"),
    CONFIGINVALIDRESPONSE("ConfigInvalidResponse"),
    CLIENTMETADATAHTTPNOTFOUND("ClientMetadataHttpNotFound"),
    CLIENTMETADATANORESPONSE("ClientMetadataNoResponse"),
    CLIENTMETADATAINVALIDRESPONSE("ClientMetadataInvalidResponse"),
    DISABLEDINSETTINGS("DisabledInSettings"),
    ERRORFETCHINGSIGNIN("ErrorFetchingSignin"),
    INVALIDSIGNINRESPONSE("InvalidSigninResponse"),
    ACCOUNTSHTTPNOTFOUND("AccountsHttpNotFound"),
    ACCOUNTSNORESPONSE("AccountsNoResponse"),
    ACCOUNTSINVALIDRESPONSE("AccountsInvalidResponse"),
    IDTOKENHTTPNOTFOUND("IdTokenHttpNotFound"),
    IDTOKENNORESPONSE("IdTokenNoResponse"),
    IDTOKENINVALIDRESPONSE("IdTokenInvalidResponse"),
    IDTOKENINVALIDREQUEST("IdTokenInvalidRequest"),
    ERRORIDTOKEN("ErrorIdToken"),
    CANCELED("Canceled"),
    RPPAGENOTVISIBLE("RpPageNotVisible");

    private String value;

    FederatedAuthRequestIssueReason(String value) {
        this.value = value;
    }

    public static FederatedAuthRequestIssueReason fromString(String s) {
        return java.util.Arrays.stream(FederatedAuthRequestIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within FederatedAuthRequestIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static FederatedAuthRequestIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
