package org.openqa.selenium.devtools.v108.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue tracks information needed to print a deprecation message.
 * https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md
 */
public class DeprecationIssueDetails {

    private final java.util.Optional<org.openqa.selenium.devtools.v108.audits.model.AffectedFrame> affectedFrame;

    private final org.openqa.selenium.devtools.v108.audits.model.SourceCodeLocation sourceCodeLocation;

    private final org.openqa.selenium.devtools.v108.audits.model.DeprecationIssueType type;

    public DeprecationIssueDetails(java.util.Optional<org.openqa.selenium.devtools.v108.audits.model.AffectedFrame> affectedFrame, org.openqa.selenium.devtools.v108.audits.model.SourceCodeLocation sourceCodeLocation, org.openqa.selenium.devtools.v108.audits.model.DeprecationIssueType type) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    public java.util.Optional<org.openqa.selenium.devtools.v108.audits.model.AffectedFrame> getAffectedFrame() {
        return affectedFrame;
    }

    public org.openqa.selenium.devtools.v108.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    public org.openqa.selenium.devtools.v108.audits.model.DeprecationIssueType getType() {
        return type;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v108.audits.model.AffectedFrame> affectedFrame = java.util.Optional.empty();
        org.openqa.selenium.devtools.v108.audits.model.SourceCodeLocation sourceCodeLocation = null;
        org.openqa.selenium.devtools.v108.audits.model.DeprecationIssueType type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "affectedFrame":
                    affectedFrame = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v108.audits.model.AffectedFrame.class));
                    break;
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v108.audits.model.SourceCodeLocation.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v108.audits.model.DeprecationIssueType.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, type);
    }
}
