package org.openqa.selenium.devtools.v107.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when HTTP request has failed to load.
 */
public class LoadingFailed {

    private final org.openqa.selenium.devtools.v107.network.model.RequestId requestId;

    private final org.openqa.selenium.devtools.v107.network.model.MonotonicTime timestamp;

    private final org.openqa.selenium.devtools.v107.network.model.ResourceType type;

    private final java.lang.String errorText;

    private final java.util.Optional<java.lang.Boolean> canceled;

    private final java.util.Optional<org.openqa.selenium.devtools.v107.network.model.BlockedReason> blockedReason;

    private final java.util.Optional<org.openqa.selenium.devtools.v107.network.model.CorsErrorStatus> corsErrorStatus;

    public LoadingFailed(org.openqa.selenium.devtools.v107.network.model.RequestId requestId, org.openqa.selenium.devtools.v107.network.model.MonotonicTime timestamp, org.openqa.selenium.devtools.v107.network.model.ResourceType type, java.lang.String errorText, java.util.Optional<java.lang.Boolean> canceled, java.util.Optional<org.openqa.selenium.devtools.v107.network.model.BlockedReason> blockedReason, java.util.Optional<org.openqa.selenium.devtools.v107.network.model.CorsErrorStatus> corsErrorStatus) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.errorText = java.util.Objects.requireNonNull(errorText, "errorText is required");
        this.canceled = canceled;
        this.blockedReason = blockedReason;
        this.corsErrorStatus = corsErrorStatus;
    }

    /**
     * Request identifier.
     */
    public org.openqa.selenium.devtools.v107.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Timestamp.
     */
    public org.openqa.selenium.devtools.v107.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    /**
     * Resource type.
     */
    public org.openqa.selenium.devtools.v107.network.model.ResourceType getType() {
        return type;
    }

    /**
     * User friendly error message.
     */
    public java.lang.String getErrorText() {
        return errorText;
    }

    /**
     * True if loading was canceled.
     */
    public java.util.Optional<java.lang.Boolean> getCanceled() {
        return canceled;
    }

    /**
     * The reason why loading was blocked, if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v107.network.model.BlockedReason> getBlockedReason() {
        return blockedReason;
    }

    /**
     * The reason why loading was blocked by CORS, if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v107.network.model.CorsErrorStatus> getCorsErrorStatus() {
        return corsErrorStatus;
    }

    private static LoadingFailed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v107.network.model.RequestId requestId = null;
        org.openqa.selenium.devtools.v107.network.model.MonotonicTime timestamp = null;
        org.openqa.selenium.devtools.v107.network.model.ResourceType type = null;
        java.lang.String errorText = null;
        java.util.Optional<java.lang.Boolean> canceled = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v107.network.model.BlockedReason> blockedReason = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v107.network.model.CorsErrorStatus> corsErrorStatus = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v107.network.model.RequestId.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v107.network.model.MonotonicTime.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v107.network.model.ResourceType.class);
                    break;
                case "errorText":
                    errorText = input.nextString();
                    break;
                case "canceled":
                    canceled = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "blockedReason":
                    blockedReason = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v107.network.model.BlockedReason.class));
                    break;
                case "corsErrorStatus":
                    corsErrorStatus = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v107.network.model.CorsErrorStatus.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LoadingFailed(requestId, timestamp, type, errorText, canceled, blockedReason, corsErrorStatus);
    }
}
