/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v105.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode;
import org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails;
import org.openqa.selenium.devtools.v105.audits.model.IssueId;
import org.openqa.selenium.json.JsonInput;

public class InspectorIssue {
    private final InspectorIssueCode code;
    private final InspectorIssueDetails details;
    private final Optional<IssueId> issueId;

    public InspectorIssue(InspectorIssueCode code, InspectorIssueDetails details, Optional<IssueId> issueId) {
        this.code = Objects.requireNonNull(code, "code is required");
        this.details = Objects.requireNonNull(details, "details is required");
        this.issueId = issueId;
    }

    public InspectorIssueCode getCode() {
        return this.code;
    }

    public InspectorIssueDetails getDetails() {
        return this.details;
    }

    public Optional<IssueId> getIssueId() {
        return this.issueId;
    }

    private static InspectorIssue fromJson(JsonInput input) {
        InspectorIssueCode code = null;
        InspectorIssueDetails details = null;
        Optional<IssueId> issueId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "code": {
                    code = (InspectorIssueCode)((Object)input.read(InspectorIssueCode.class));
                    continue block10;
                }
                case "details": {
                    details = (InspectorIssueDetails)input.read(InspectorIssueDetails.class);
                    continue block10;
                }
                case "issueId": {
                    issueId = Optional.ofNullable((IssueId)input.read(IssueId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InspectorIssue(code, details, issueId);
    }
}

